/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.remote;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.core.document.DefaultDocumentFormatRegistry;
import org.jodconverter.core.document.DocumentFormatRegistry;
import org.jodconverter.core.job.AbstractConversionJob;
import org.jodconverter.core.job.AbstractConversionJobWithSourceFormatUnspecified;
import org.jodconverter.core.job.AbstractConverter;
import org.jodconverter.core.job.AbstractSourceDocumentSpecs;
import org.jodconverter.core.job.AbstractTargetDocumentSpecs;
import org.jodconverter.core.job.SourceDocumentSpecs;
import org.jodconverter.core.job.TargetDocumentSpecs;
import org.jodconverter.core.office.InstalledOfficeManagerHolder;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.core.task.OfficeTask;
import org.jodconverter.remote.task.RemoteConversionTask;

public final class RemoteConverter
extends AbstractConverter {
    public static @NonNull Builder builder() {
        return new Builder();
    }

    public static @NonNull RemoteConverter make() {
        return RemoteConverter.builder().build();
    }

    public static @NonNull RemoteConverter make(@NonNull OfficeManager officeManager) {
        return ((Builder)RemoteConverter.builder().officeManager(officeManager)).build();
    }

    private RemoteConverter(OfficeManager officeManager, DocumentFormatRegistry formatRegistry) {
        super(officeManager, formatRegistry);
    }

    protected @NonNull AbstractConversionJobWithSourceFormatUnspecified convert(@NonNull AbstractSourceDocumentSpecs source) {
        return new RemoteConversionJobWithSourceFormatUnspecified(source);
    }

    public static final class Builder
    extends AbstractConverter.AbstractConverterBuilder<Builder> {
        private Builder() {
        }

        public @NonNull RemoteConverter build() {
            OfficeManager manager = this.officeManager;
            if (manager == null && (manager = InstalledOfficeManagerHolder.getInstance()) == null) {
                throw new IllegalStateException("An office manager is required in order to build a converter.");
            }
            return new RemoteConverter(manager, this.formatRegistry == null ? DefaultDocumentFormatRegistry.getInstance() : this.formatRegistry);
        }
    }

    private class RemoteConversionJob
    extends AbstractConversionJob {
        private RemoteConversionJob(AbstractSourceDocumentSpecs source, AbstractTargetDocumentSpecs target) {
            super(source, target);
        }

        public void doExecute() throws OfficeException {
            RemoteConversionTask task = new RemoteConversionTask((SourceDocumentSpecs)this.source, (TargetDocumentSpecs)this.target);
            RemoteConverter.this.officeManager.execute((OfficeTask)task);
        }
    }

    private class RemoteConversionJobWithSourceFormatUnspecified
    extends AbstractConversionJobWithSourceFormatUnspecified {
        private RemoteConversionJobWithSourceFormatUnspecified(AbstractSourceDocumentSpecs source) {
            super(source, RemoteConverter.this.officeManager, RemoteConverter.this.formatRegistry);
        }

        protected @NonNull AbstractConversionJob to(@NonNull AbstractTargetDocumentSpecs target) {
            return new RemoteConversionJob(this.source, target);
        }
    }
}

