/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.remote.office;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.PrivateKeyDetails;
import org.apache.http.ssl.PrivateKeyStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.jodconverter.core.office.AbstractOfficeManagerPoolEntry;
import org.jodconverter.core.office.OfficeContext;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.core.task.OfficeTask;
import org.jodconverter.core.util.AssertUtils;
import org.jodconverter.core.util.StringUtils;
import org.jodconverter.remote.office.RemoteOfficeConnection;
import org.jodconverter.remote.office.RequestConfig;
import org.jodconverter.remote.ssl.SslConfig;

class RemoteOfficeManagerPoolEntry
extends AbstractOfficeManagerPoolEntry {
    private final String connectionUrl;
    private final SslConfig sslConfig;
    private final long connectTimeout;
    private final long socketTimeout;

    private static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = RemoteOfficeManagerPoolEntry.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    private static File getFile(URL url) {
        try {
            return new File(new URI(url.toString().replace(" ", "%20")).getSchemeSpecificPart());
        }
        catch (URISyntaxException ex) {
            return new File(url.getFile());
        }
    }

    private static File getFile(String resourceLocation) throws FileNotFoundException {
        AssertUtils.notNull((Object)resourceLocation, (String)"resourceLocation must not be null");
        if (resourceLocation.startsWith("classpath:")) {
            URL url;
            String path = resourceLocation.substring("classpath:".length());
            String description = "class path resource [" + path + "]";
            ClassLoader cl = RemoteOfficeManagerPoolEntry.getDefaultClassLoader();
            URL uRL = url = cl == null ? ClassLoader.getSystemResource(path) : cl.getResource(path);
            if (url == null) {
                throw new FileNotFoundException(description + " cannot be resolved to absolute file path because it does not exist");
            }
            return RemoteOfficeManagerPoolEntry.getFile(url.toString());
        }
        try {
            return RemoteOfficeManagerPoolEntry.getFile(new URL(resourceLocation));
        }
        catch (MalformedURLException ex) {
            return new File(resourceLocation);
        }
    }

    RemoteOfficeManagerPoolEntry(String connectionUrl, SslConfig sslConfig, long connectTimeout, long socketTimeout, long taskExecutionTimeout) {
        super(taskExecutionTimeout);
        this.connectionUrl = connectionUrl;
        this.sslConfig = sslConfig;
        this.connectTimeout = connectTimeout;
        this.socketTimeout = socketTimeout;
    }

    private String buildUrl(String connectionUrl) throws MalformedURLException {
        URL url = new URL(connectionUrl);
        String path = url.toExternalForm().toLowerCase(Locale.ROOT);
        if (StringUtils.endsWithAny((String)path, (String[])new String[]{"lool/convert-to", "lool/convert-to/"})) {
            return StringUtils.appendIfMissing((String)connectionUrl, (String)"/");
        }
        if (StringUtils.endsWithAny((String)path, (String[])new String[]{"lool", "lool/"})) {
            return StringUtils.appendIfMissing((String)connectionUrl, (String)"/") + "convert-to/";
        }
        return StringUtils.appendIfMissing((String)connectionUrl, (String)"/") + "lool/convert-to/";
    }

    private void configureKeyMaterial(SSLContextBuilder sslBuilder) throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, NoSuchProviderException {
        KeyStore keystore = this.loadStore(this.sslConfig.getKeyStore(), this.sslConfig.getKeyStorePassword(), this.sslConfig.getKeyStoreType(), this.sslConfig.getKeyStoreProvider());
        if (keystore != null) {
            sslBuilder.loadKeyMaterial(keystore, this.sslConfig.getKeyPassword() == null ? Objects.requireNonNull(this.sslConfig.getKeyStorePassword()).toCharArray() : this.sslConfig.getKeyPassword().toCharArray(), (PrivateKeyStrategy)(this.sslConfig.getKeyAlias() == null ? null : new SelectByAlias(this.sslConfig.getKeyAlias())));
        }
    }

    private SSLConnectionSocketFactory configureSsl() throws OfficeException {
        if (this.sslConfig == null || !this.sslConfig.isEnabled()) {
            return null;
        }
        try {
            SSLContextBuilder sslBuilder = SSLContexts.custom();
            sslBuilder.setProtocol(this.sslConfig.getProtocol());
            this.configureKeyMaterial(sslBuilder);
            this.configureTrustMaterial(sslBuilder);
            SSLContext sslcontext = sslBuilder.build();
            return new SSLConnectionSocketFactory(sslcontext, this.sslConfig.getEnabledProtocols(), this.sslConfig.getCiphers(), this.sslConfig.isVerifyHostname() ? SSLConnectionSocketFactory.getDefaultHostnameVerifier() : NoopHostnameVerifier.INSTANCE);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | UnrecoverableKeyException | CertificateException ex) {
            throw new OfficeException("Could not create SSL context.", (Throwable)ex);
        }
    }

    private void configureTrustMaterial(SSLContextBuilder sslBuilder) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, NoSuchProviderException {
        if (this.sslConfig.isTrustAll()) {
            sslBuilder.loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)TrustAllStrategy.INSTANCE);
        } else {
            KeyStore truststore = this.loadStore(this.sslConfig.getTrustStore(), this.sslConfig.getTrustStorePassword(), this.sslConfig.getTrustStoreType(), this.sslConfig.getTrustStoreProvider());
            if (truststore != null) {
                sslBuilder.loadTrustMaterial(truststore, null);
            }
        }
    }

    protected void doExecute(OfficeTask task) throws OfficeException {
        SSLConnectionSocketFactory sslFactory = this.configureSsl();
        try (CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslFactory).build();){
            RequestConfig requestConfig = new RequestConfig(this.buildUrl(this.connectionUrl), this.connectTimeout, this.socketTimeout);
            task.execute((OfficeContext)new RemoteOfficeConnection(httpClient, requestConfig));
        }
        catch (IOException ex) {
            throw new OfficeException("Could not create the HTTP client", (Throwable)ex);
        }
    }

    protected void doStart() {
        this.setAvailable(true);
    }

    protected void doStop() {
    }

    private KeyStore loadStore(String store, String storePassword, String storeType, String storeProvider) throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException, NoSuchProviderException {
        if (store != null) {
            AssertUtils.notNull((Object)storePassword, (String)String.format("storePassword of store %s must not be null", store));
            String type = storeType == null ? KeyStore.getDefaultType() : storeType;
            KeyStore keyStore = storeProvider == null ? KeyStore.getInstance(type) : KeyStore.getInstance(type, storeProvider);
            try (InputStream instream = Files.newInputStream(RemoteOfficeManagerPoolEntry.getFile(store).toPath(), new OpenOption[0]);){
                keyStore.load(instream, storePassword.toCharArray());
            }
            return keyStore;
        }
        return null;
    }

    private static final class TrustAllStrategy
    implements TrustStrategy {
        private static final TrustAllStrategy INSTANCE = new TrustAllStrategy();

        private TrustAllStrategy() {
        }

        public boolean isTrusted(X509Certificate[] chain, String authType) {
            return true;
        }
    }

    private static final class SelectByAlias
    implements PrivateKeyStrategy {
        private final String keyAlias;

        public SelectByAlias(String keyAlias) {
            this.keyAlias = keyAlias;
        }

        public String chooseAlias(Map<String, PrivateKeyDetails> aliases, Socket socket) {
            return aliases.keySet().stream().filter(key -> key.equalsIgnoreCase(this.keyAlias)).findFirst().orElse(null);
        }
    }
}

