/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.boot.autoconfigure;

import java.io.InputStream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.boot.autoconfigure.JodConverterLocalProperties;
import org.jodconverter.core.DocumentConverter;
import org.jodconverter.core.document.DefaultDocumentFormatRegistryInstanceHolder;
import org.jodconverter.core.document.DocumentFormatRegistry;
import org.jodconverter.core.document.JsonDocumentFormatRegistry;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.core.util.StringUtils;
import org.jodconverter.local.LocalConverter;
import org.jodconverter.local.office.LocalOfficeManager;
import org.jodconverter.local.office.LocalOfficeUtils;
import org.jodconverter.local.process.ProcessManager;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;

@Configuration
@ConditionalOnClass(value={LocalConverter.class})
@ConditionalOnProperty(prefix="jodconverter.local", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={JodConverterLocalProperties.class})
public class JodConverterLocalAutoConfiguration {
    private final JodConverterLocalProperties properties;

    public JodConverterLocalAutoConfiguration(@NonNull JodConverterLocalProperties properties) {
        this.properties = properties;
    }

    private OfficeManager createOfficeManager(ProcessManager processManager) {
        LocalOfficeManager.Builder builder = ((LocalOfficeManager.Builder)((LocalOfficeManager.Builder)((LocalOfficeManager.Builder)LocalOfficeManager.builder().officeHome(this.properties.getOfficeHome()).hostName(this.properties.getHostName()).portNumbers(this.properties.getPortNumbers()).workingDir(this.properties.getWorkingDir())).templateProfileDir(this.properties.getTemplateProfileDir()).existingProcessAction(this.properties.getExistingProcessAction()).processTimeout(Long.valueOf(this.properties.getProcessTimeout())).processRetryInterval(Long.valueOf(this.properties.getProcessRetryInterval())).afterStartProcessDelay(Long.valueOf(this.properties.getAfterStartProcessDelay())).disableOpengl(Boolean.valueOf(this.properties.isDisableOpengl())).startFailFast(Boolean.valueOf(this.properties.isStartFailFast())).keepAliveOnShutdown(Boolean.valueOf(this.properties.isKeepAliveOnShutdown())).taskQueueTimeout(Long.valueOf(this.properties.getTaskQueueTimeout()))).taskExecutionTimeout(Long.valueOf(this.properties.getTaskExecutionTimeout()))).maxTasksPerProcess(Integer.valueOf(this.properties.getMaxTasksPerProcess()));
        if (StringUtils.isBlank((String)this.properties.getProcessManagerClass())) {
            builder.processManager(processManager);
        } else {
            builder.processManager(this.properties.getProcessManagerClass());
        }
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean(name={"processManager"})
    ProcessManager processManager() {
        return LocalOfficeUtils.findBestProcessManager();
    }

    @Bean
    @ConditionalOnMissingBean(name={"documentFormatRegistry"})
    DocumentFormatRegistry documentFormatRegistry(ResourceLoader resourceLoader) throws Exception {
        try (InputStream in = StringUtils.isBlank((String)this.properties.getDocumentFormatRegistry()) ? resourceLoader.getResource("classpath:document-formats.json").getInputStream() : resourceLoader.getResource(this.properties.getDocumentFormatRegistry()).getInputStream();){
            JsonDocumentFormatRegistry registry = this.properties.getFormatOptions() == null ? JsonDocumentFormatRegistry.create((InputStream)in) : JsonDocumentFormatRegistry.create((InputStream)in, this.properties.getFormatOptions());
            DefaultDocumentFormatRegistryInstanceHolder.setInstance((DocumentFormatRegistry)registry);
            JsonDocumentFormatRegistry jsonDocumentFormatRegistry = registry;
            return jsonDocumentFormatRegistry;
        }
    }

    @Bean(name={"localOfficeManager"}, initMethod="start", destroyMethod="stop")
    @ConditionalOnMissingBean(name={"localOfficeManager"})
    OfficeManager localOfficeManager(ProcessManager processManager) {
        return this.createOfficeManager(processManager);
    }

    @Bean
    @ConditionalOnMissingBean(name={"localDocumentConverter"})
    @ConditionalOnBean(name={"localOfficeManager", "documentFormatRegistry"})
    DocumentConverter localDocumentConverter(OfficeManager localOfficeManager, DocumentFormatRegistry documentFormatRegistry) {
        return ((LocalConverter.Builder)((LocalConverter.Builder)LocalConverter.builder().officeManager(localOfficeManager)).formatRegistry(documentFormatRegistry)).build();
    }
}

