/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.spring;

import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jodconverter.core.DocumentConverter;
import org.jodconverter.core.document.DefaultDocumentFormatRegistry;
import org.jodconverter.core.document.DocumentFamily;
import org.jodconverter.core.document.DocumentFormat;
import org.jodconverter.core.document.DocumentFormatRegistry;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.core.office.OfficeUtils;
import org.jodconverter.local.LocalConverter;
import org.jodconverter.local.office.LocalOfficeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class JodConverterBean
implements InitializingBean,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(JodConverterBean.class);
    private String officeHome;
    private String portNumbers;
    private String workingDir;
    private String templateProfileDir;
    private Boolean killExistingProcess = true;
    private Long processTimeout = 120000L;
    private Long processRetryInterval = 250L;
    private Long taskExecutionTimeout = 120000L;
    private Integer maxTasksPerProcess = 200;
    private Long taskQueueTimeout = 30000L;
    private OfficeManager officeManager;
    private DocumentConverter documentConverter;

    public void afterPropertiesSet() throws OfficeException {
        LocalOfficeManager.Builder builder = LocalOfficeManager.builder();
        if (!StringUtils.isBlank((CharSequence)this.portNumbers)) {
            builder.portNumbers(ArrayUtils.toPrimitive((Integer[])((Integer[])Stream.of(StringUtils.split((String)this.portNumbers, (String)", ")).map(str -> NumberUtils.toInt((String)str, (int)2002)).toArray(Integer[]::new))));
        }
        builder.officeHome(this.officeHome);
        builder.workingDir(this.workingDir);
        builder.templateProfileDir(this.templateProfileDir);
        builder.killExistingProcess(this.killExistingProcess);
        builder.processTimeout(this.processTimeout);
        builder.processRetryInterval(this.processRetryInterval);
        builder.taskExecutionTimeout(this.taskExecutionTimeout);
        builder.maxTasksPerProcess(this.maxTasksPerProcess);
        builder.taskQueueTimeout(this.taskQueueTimeout);
        this.officeManager = builder.build();
        this.documentConverter = LocalConverter.make((OfficeManager)this.officeManager);
        this.officeManager.start();
    }

    public @NonNull DocumentConverter getConverter() {
        return this.documentConverter;
    }

    public void destroy() {
        OfficeUtils.stopQuietly((OfficeManager)this.officeManager);
    }

    public void logAvailableFormats() {
        DocumentFormatRegistry ref = DefaultDocumentFormatRegistry.getInstance();
        Set formats = ref.getOutputFormats(DocumentFamily.TEXT);
        this.logSupportedGroupFormats("Supported Text Document Formats are:", formats);
        formats = ref.getOutputFormats(DocumentFamily.SPREADSHEET);
        this.logSupportedGroupFormats("Supported SpreadSheet Document Formats are:", formats);
        formats = ref.getOutputFormats(DocumentFamily.PRESENTATION);
        this.logSupportedGroupFormats("Supported Presentation Document Formats are:", formats);
        formats = ref.getOutputFormats(DocumentFamily.DRAWING);
        this.logSupportedGroupFormats("Supported Drawing Document Formats are:", formats);
    }

    private void logSupportedGroupFormats(String text, Set<DocumentFormat> formats) {
        LOGGER.info(text);
        formats.stream().map(DocumentFormat::getName).forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
    }

    public void setKillExistingProcess(@Nullable Boolean killExistingProcess) {
        this.killExistingProcess = killExistingProcess;
    }

    public void setMaxTasksPerProcess(@Nullable Integer maxTasksPerProcess) {
        this.maxTasksPerProcess = maxTasksPerProcess;
    }

    public void setOfficeHome(@Nullable String officeHome) {
        this.officeHome = officeHome;
    }

    public void setPortNumbers(@Nullable String portNumbers) {
        this.portNumbers = portNumbers;
    }

    public void setProcessRetryInterval(@Nullable Long processRetryInterval) {
        this.processRetryInterval = processRetryInterval;
    }

    public void setProcessTimeout(@Nullable Long processTimeout) {
        this.processTimeout = processTimeout;
    }

    public void setTaskExecutionTimeout(@Nullable Long taskExecutionTimeout) {
        this.taskExecutionTimeout = taskExecutionTimeout;
    }

    public void setTaskQueueTimeout(@Nullable Long taskQueueTimeout) {
        this.taskQueueTimeout = taskQueueTimeout;
    }

    public void setTemplateProfileDir(@Nullable String templateProfileDir) {
        this.templateProfileDir = templateProfileDir;
    }

    public void setWorkingDir(@Nullable String workingDir) {
        this.workingDir = workingDir;
    }
}

