/*
 * Decompiled with CFR 0.152.
 */
package jodd.csselly.selector;

import jodd.csselly.CSSellyException;
import jodd.util.StringUtil;

public class PseudoFunctionExpression {
    protected final int a;
    protected final int b;

    public PseudoFunctionExpression(String expression) {
        expression = StringUtil.removeChars(expression, "+ \t\n\r\n");
        if (expression.equals("odd")) {
            this.a = 2;
            this.b = 1;
        } else if (expression.equals("even")) {
            this.a = 2;
            this.b = 0;
        } else {
            int nndx = expression.indexOf(110);
            if (nndx != -1) {
                String aVal = expression.substring(0, nndx).trim();
                this.a = aVal.length() == 0 ? 1 : (aVal.equals("-") ? -1 : this.parseInt(aVal));
                String bVal = expression.substring(nndx + 1);
                this.b = bVal.length() == 0 ? 0 : this.parseInt(bVal);
            } else {
                this.a = 0;
                this.b = this.parseInt(expression);
            }
        }
    }

    protected int parseInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfex) {
            throw new CSSellyException(nfex);
        }
    }

    public int getValueA() {
        return this.a;
    }

    public int getValueB() {
        return this.b;
    }

    public boolean match(int value) {
        if (this.a == 0) {
            return value == this.b;
        }
        if (this.a > 0) {
            if (value < this.b) {
                return false;
            }
            return (value - this.b) % this.a == 0;
        }
        if (value > this.b) {
            return false;
        }
        return (this.b - value) % -this.a == 0;
    }
}

