/*
 * Decompiled with CFR 0.152.
 */
package jodd.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import jodd.db.connection.ConnectionProvider;
import jodd.db.oom.DbOomManager;
import jodd.log.Logger;
import jodd.log.LoggerFactory;

public class DbDetector {
    private static final Logger log = LoggerFactory.getLogger(DbDetector.class);

    public static Db detectDatabaseAndConfigureDbOom(ConnectionProvider cp) {
        cp.init();
        Connection connection = cp.getConnection();
        Db db = DbDetector.detectDatabase(connection);
        cp.closeConnection(connection);
        db.configure();
        return db;
    }

    public static Db detectDatabase(Connection connection) {
        int dbMajorVersion;
        String dbName;
        try {
            log.info("Detecting database...");
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            dbName = databaseMetaData.getDatabaseProductName();
            dbMajorVersion = databaseMetaData.getDatabaseMajorVersion();
            int dbMinorVersion = databaseMetaData.getDatabaseMinorVersion();
            log.info("Database: " + dbName + " v" + dbMajorVersion + "." + dbMinorVersion);
        }
        catch (SQLException sex) {
            String msg = sex.getMessage();
            if (msg.contains("explicitly set for database: DB2")) {
                return Db.DB2;
            }
            return Db.UNKNOWN;
        }
        if (dbName.equals("Apache Derby")) {
            return Db.DERBY;
        }
        if (dbName.startsWith("DB2/")) {
            return Db.DB2;
        }
        if (dbName.equals("HSQL Database Engine")) {
            return Db.HSQL;
        }
        if (dbName.equals("Informix Dynamic Server")) {
            return Db.INFORMIX;
        }
        if (dbName.startsWith("Microsoft SQL Server")) {
            return Db.SQL_SERVER;
        }
        if (dbName.equals("MySQL")) {
            return Db.MYSQL;
        }
        if (dbName.equals("Oracle")) {
            return Db.ORACLE;
        }
        if (dbName.equals("PostgreSQL")) {
            return Db.POSTGRESQL;
        }
        if (dbName.equals("Sybase SQL Server")) {
            return Db.SYBASE;
        }
        if (dbName.equals("ASE") && dbMajorVersion == 15) {
            return Db.SYBASE;
        }
        return Db.UNKNOWN;
    }

    public static enum Db implements DbOomConfigurator
    {
        UNKNOWN{

            @Override
            public void configure() {
            }
        }
        ,
        DERBY{

            @Override
            public void configure() {
            }
        }
        ,
        DB2{

            @Override
            public void configure() {
            }
        }
        ,
        HSQL{

            @Override
            public void configure() {
                DbOomManager dboom = DbOomManager.getInstance();
                dboom.getTableNames().setLowercase(true);
                dboom.getColumnNames().setLowercase(true);
            }
        }
        ,
        INFORMIX{

            @Override
            public void configure() {
            }
        }
        ,
        SQL_SERVER{

            @Override
            public void configure() {
            }
        }
        ,
        MYSQL{

            @Override
            public void configure() {
            }
        }
        ,
        ORACLE{

            @Override
            public void configure() {
            }
        }
        ,
        POSTGRESQL{

            @Override
            public void configure() {
                DbOomManager dboom = DbOomManager.getInstance();
                dboom.getTableNames().setLowercase(true);
                dboom.getColumnNames().setLowercase(true);
            }
        }
        ,
        SYBASE{

            @Override
            public void configure() {
            }
        };

    }

    @FunctionalInterface
    public static interface DbOomConfigurator {
        public void configure();
    }
}

