/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom;

import java.util.HashMap;
import java.util.Map;
import jodd.db.oom.ColumnAliasType;
import jodd.db.oom.DbEntityDescriptor;
import jodd.db.oom.DbOomException;
import jodd.db.oom.JoinHintResolver;
import jodd.db.oom.NamedValuesHashMap;
import jodd.db.oom.naming.ColumnNamingStrategy;
import jodd.db.oom.naming.TableNamingStrategy;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.util.StringUtil;

public class DbOomManager {
    private static final Logger log = LoggerFactory.getLogger(DbOomManager.class);
    private static DbOomManager dbOomManager = new DbOomManager();
    protected String schemaName;
    protected TableNamingStrategy tableNames = new TableNamingStrategy();
    protected ColumnNamingStrategy columnNames = new ColumnNamingStrategy();
    protected String[] primitiveEntitiesPrefixes = new String[]{"java.lang.", "jodd.mutable.", Integer.TYPE.getName(), Long.TYPE.getName(), Float.TYPE.getName(), Double.TYPE.getName(), Short.TYPE.getName(), Boolean.TYPE.getName(), Byte.TYPE.getName()};
    protected Map<Class, DbEntityDescriptor> descriptorsMap = new HashMap<Class, DbEntityDescriptor>();
    protected Map<String, DbEntityDescriptor> entityNamesMap = new HashMap<String, DbEntityDescriptor>();
    protected Map<String, DbEntityDescriptor> tableNamesMap = new NamedValuesHashMap<DbEntityDescriptor>();
    protected String columnAliasSeparator = "$";
    protected JoinHintResolver hintResolver = new JoinHintResolver();
    protected ColumnAliasType defaultColumnAliasType;
    protected boolean cacheEntitiesInResultSet;
    protected boolean entityAwareMode;

    public static DbOomManager getInstance() {
        return dbOomManager;
    }

    public static void setInstance(DbOomManager oomManager) {
        dbOomManager = oomManager;
    }

    public static void resetAll() {
        dbOomManager = new DbOomManager();
    }

    public TableNamingStrategy getTableNames() {
        return this.tableNames;
    }

    public void setTableNames(TableNamingStrategy tableNames) {
        this.tableNames = tableNames;
    }

    public ColumnNamingStrategy getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(ColumnNamingStrategy columnNames) {
        this.columnNames = columnNames;
    }

    public String[] getPrimitiveEntitiesPrefixes() {
        return this.primitiveEntitiesPrefixes;
    }

    public void setPrimitiveEntitiesPrefixes(String ... primitiveEntitiesPrefixes) {
        this.primitiveEntitiesPrefixes = primitiveEntitiesPrefixes;
    }

    public <E> DbEntityDescriptor<E> lookupType(Class<E> type) {
        String typeName = type.getName();
        if (StringUtil.startsWithOne(typeName, this.primitiveEntitiesPrefixes) != -1) {
            return null;
        }
        DbEntityDescriptor<E> ded = this.descriptorsMap.get(type);
        if (ded == null) {
            ded = this.registerType(type);
        }
        return ded;
    }

    public boolean isRegistered(Class type) {
        return this.descriptorsMap.containsKey(type);
    }

    public DbEntityDescriptor lookupName(String typeName) {
        return this.entityNamesMap.get(typeName);
    }

    public DbEntityDescriptor lookupTableName(String tableName) {
        return this.tableNamesMap.get(tableName);
    }

    public <E> DbEntityDescriptor<E> registerType(Class<E> type) {
        DbEntityDescriptor<E> ded = this.createDbEntityDescriptor(type);
        DbEntityDescriptor<E> existing = this.descriptorsMap.put(type, ded);
        if (log.isDebugEnabled()) {
            log.debug("Register " + type.getName() + " as " + ded.getTableName());
        }
        if (existing != null) {
            if (ded.getType() == type) {
                return ded;
            }
            throw new DbOomException("Type already registered: " + existing.getType());
        }
        existing = this.entityNamesMap.put(ded.getEntityName(), ded);
        if (existing != null) {
            throw new DbOomException("Name '" + ded.getEntityName() + "' already mapped to an entity: " + existing.getType());
        }
        return ded;
    }

    public <E> DbEntityDescriptor<E> registerEntity(Class<E> type) {
        DbEntityDescriptor<E> ded = this.registerType(type);
        DbEntityDescriptor<E> existing = this.tableNamesMap.put(ded.getTableName(), ded);
        if (existing != null) {
            if (ded.getType() == type) {
                return ded;
            }
            throw new DbOomException("Entity registration failed! Table '" + ded.getTableName() + "' already mapped to an entity: " + existing.getType());
        }
        return ded;
    }

    public <E> DbEntityDescriptor<E> registerEntity(Class<E> type, boolean force) {
        if (force) {
            this.removeEntity(type);
        }
        return this.registerEntity(type);
    }

    public <E> DbEntityDescriptor<E> removeEntity(Class<E> type) {
        DbEntityDescriptor<E> ded = this.descriptorsMap.remove(type);
        if (ded == null) {
            ded = this.createDbEntityDescriptor(type);
        }
        this.entityNamesMap.remove(ded.getEntityName());
        this.tableNamesMap.remove(ded.getTableName());
        return ded;
    }

    protected <E> DbEntityDescriptor<E> createDbEntityDescriptor(Class<E> type) {
        return new DbEntityDescriptor<E>(type, this.schemaName, this.tableNames, this.columnNames);
    }

    public int getTotalNames() {
        return this.entityNamesMap.size();
    }

    public int getTotalTableNames() {
        return this.tableNamesMap.size();
    }

    public int getTotalTypes() {
        return this.descriptorsMap.size();
    }

    public void reset() {
        this.descriptorsMap.clear();
        this.entityNamesMap.clear();
        this.tableNamesMap.clear();
    }

    public String getColumnAliasSeparator() {
        return this.columnAliasSeparator;
    }

    public void setColumnAliasSeparator(String separator) {
        this.columnAliasSeparator = separator;
    }

    public JoinHintResolver getHintResolver() {
        return this.hintResolver;
    }

    public void setHintResolver(JoinHintResolver hintResolver) {
        this.hintResolver = hintResolver;
    }

    public ColumnAliasType getDefaultColumnAliasType() {
        return this.defaultColumnAliasType;
    }

    public void setDefaultColumnAliasType(ColumnAliasType defaultColumnAliasType) {
        this.defaultColumnAliasType = defaultColumnAliasType;
    }

    public boolean isCacheEntitiesInResultSet() {
        return this.cacheEntitiesInResultSet;
    }

    public void setCacheEntitiesInResultSet(boolean cacheEntitiesInResultSet) {
        this.cacheEntitiesInResultSet = cacheEntitiesInResultSet;
    }

    public boolean isEntityAwareMode() {
        return this.entityAwareMode;
    }

    public void setEntityAwareMode(boolean entityAwareMode) {
        if (entityAwareMode) {
            this.cacheEntitiesInResultSet = true;
        }
        this.entityAwareMode = entityAwareMode;
    }

    public <E> E createEntityInstance(Class<E> type) {
        try {
            return type.newInstance();
        }
        catch (Exception ex) {
            throw new DbOomException(ex);
        }
    }
}

