/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom.sqlgen.chunks;

import jodd.db.oom.ColumnAliasType;
import jodd.db.oom.DbEntityColumnDescriptor;
import jodd.db.oom.DbEntityDescriptor;
import jodd.db.oom.sqlgen.DbSqlBuilderException;
import jodd.db.oom.sqlgen.TemplateData;
import jodd.db.oom.sqlgen.chunks.SqlChunk;
import jodd.util.ArraysUtil;
import jodd.util.StringUtil;

public class ColumnsSelectChunk
extends SqlChunk {
    private static final String AS = " as ";
    private static final char SPLIT = ',';
    protected final String tableRef;
    protected final String columnRef;
    protected final String[] columnRefArr;
    protected final int includeColumns;
    protected final String hint;

    protected ColumnsSelectChunk(String tableRef, String columnRef, String[] columnRefArr, int includeColumns, String hint) {
        super(1);
        this.tableRef = tableRef;
        this.columnRef = columnRef;
        this.columnRefArr = columnRefArr;
        this.includeColumns = includeColumns;
        this.hint = hint;
    }

    public ColumnsSelectChunk(String tableRef, String columnRef) {
        this(tableRef, columnRef, null, 0, null);
    }

    public ColumnsSelectChunk(String tableRef, String ... columnRefArr) {
        this(tableRef, null, columnRefArr, 0, null);
    }

    public ColumnsSelectChunk(String tableRef, boolean includeAll) {
        this(tableRef, null, null, includeAll ? 3 : 2, null);
    }

    public ColumnsSelectChunk(String reference) {
        super(1);
        reference = reference.trim();
        int dotNdx = reference.lastIndexOf(46);
        if (dotNdx == -1) {
            this.tableRef = reference;
            this.columnRef = null;
            this.columnRefArr = null;
            this.includeColumns = 3;
            this.hint = null;
        } else {
            String tref = reference.substring(0, dotNdx);
            reference = reference.substring(dotNdx + 1);
            dotNdx = tref.lastIndexOf(46);
            if (dotNdx == -1) {
                this.tableRef = tref;
                this.hint = null;
            } else {
                int doubleColumnNdx = tref.indexOf(58);
                if (doubleColumnNdx == -1) {
                    this.tableRef = tref.substring(dotNdx + 1);
                    this.hint = tref;
                } else {
                    this.tableRef = tref.substring(doubleColumnNdx + 1);
                    this.hint = tref.substring(0, doubleColumnNdx);
                }
            }
            if (reference.equals("*")) {
                this.columnRef = null;
                this.columnRefArr = null;
                this.includeColumns = 3;
            } else if (reference.equals("+")) {
                this.columnRef = null;
                this.columnRefArr = null;
                this.includeColumns = 2;
            } else if (reference.equals("%")) {
                this.columnRef = null;
                this.columnRefArr = null;
                this.includeColumns = 4;
            } else if (reference.length() != 0 && reference.charAt(0) == '[' && reference.charAt(reference.length() - 1) == ']') {
                this.columnRef = null;
                this.columnRefArr = StringUtil.splitc(reference.substring(1, reference.length() - 1), ',');
                StringUtil.trimAll(this.columnRefArr);
                this.includeColumns = 0;
            } else {
                this.columnRef = reference;
                this.columnRefArr = null;
                this.includeColumns = 0;
            }
        }
    }

    @Override
    public void init(TemplateData templateData) {
        super.init(templateData);
        if (this.hint != null) {
            templateData.incrementHintsCount();
        }
    }

    @Override
    public void process(StringBuilder out) {
        if (this.templateData.hasHints()) {
            this.templateData.registerHint(this.hint == null ? this.tableRef : this.hint);
        }
        this.separateByCommaOrSpace(out);
        if (this.tableRef.length() == 0) {
            out.append(this.columnRef);
            return;
        }
        boolean useTableReference = true;
        DbEntityDescriptor ded = this.lookupTableRef(this.tableRef, false);
        if (ded == null) {
            useTableReference = false;
            ded = this.lookupName(this.tableRef);
        }
        if (this.columnRef == null) {
            DbEntityColumnDescriptor[] decList = ded.getColumnDescriptors();
            int count = 0;
            boolean withIds = this.columnRefArr != null && ArraysUtil.contains(this.columnRefArr, "+");
            for (DbEntityColumnDescriptor dec : decList) {
                if (this.includeColumns == 2 && !dec.isId() || this.includeColumns == 4 && dec.isId() || this.includeColumns == 0 && (!withIds || !dec.isId()) && !ArraysUtil.contains(this.columnRefArr, dec.getPropertyName())) continue;
                if (count > 0) {
                    out.append(',').append(' ');
                }
                this.templateData.lastColumnDec = dec;
                if (useTableReference) {
                    this.appendColumnName(out, ded, dec.getColumnName());
                } else {
                    this.appendAlias(out, ded, dec.getColumnName());
                }
                ++count;
            }
        } else {
            String columnName;
            DbEntityColumnDescriptor dec;
            this.templateData.lastColumnDec = dec = ded.findByPropertyName(this.columnRef);
            String string = columnName = dec == null ? null : dec.getColumnName();
            if (columnName == null) {
                throw new DbSqlBuilderException("Invalid column reference: " + this.tableRef + '.' + this.columnRef);
            }
            if (useTableReference) {
                this.appendColumnName(out, ded, columnName);
            } else {
                this.appendAlias(out, ded, columnName);
            }
        }
    }

    protected void appendAlias(StringBuilder query, DbEntityDescriptor ded, String column) {
        String tableName = ded.getTableName();
        ColumnAliasType columnAliasType = this.templateData.getColumnAliasType();
        String columnAliasSeparator = this.templateData.getDbOomManager().getColumnAliasSeparator();
        if (columnAliasType == null || columnAliasType == ColumnAliasType.TABLE_REFERENCE) {
            this.templateData.registerColumnDataForTableRef(this.tableRef, tableName);
            query.append(this.tableRef).append(columnAliasSeparator).append(column);
        } else if (columnAliasType == ColumnAliasType.COLUMN_CODE) {
            String code = this.templateData.registerColumnDataForColumnCode(tableName, column);
            query.append(code);
        } else if (columnAliasType == ColumnAliasType.TABLE_NAME) {
            query.append(tableName).append(columnAliasSeparator).append(column);
        }
    }

    protected void appendColumnName(StringBuilder query, DbEntityDescriptor ded, String column) {
        query.append(this.resolveTable(this.tableRef, ded)).append('.').append(column);
        if (this.templateData.getColumnAliasType() != null) {
            String tableName = ded.getTableName();
            query.append(AS);
            switch (this.templateData.getColumnAliasType()) {
                case TABLE_NAME: {
                    query.append(tableName).append(this.templateData.getDbOomManager().getColumnAliasSeparator()).append(column);
                    break;
                }
                case TABLE_REFERENCE: {
                    this.templateData.registerColumnDataForTableRef(this.tableRef, tableName);
                    query.append(this.tableRef).append(this.templateData.getDbOomManager().getColumnAliasSeparator()).append(column);
                    break;
                }
                case COLUMN_CODE: {
                    String code = this.templateData.registerColumnDataForColumnCode(tableName, column);
                    query.append(code);
                }
            }
        }
    }
}

