/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.injector;

import jodd.madvoc.ActionConfig;
import jodd.madvoc.ActionConfigSet;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.ScopeData;
import jodd.madvoc.ScopeType;
import jodd.madvoc.component.ScopeDataResolver;
import jodd.madvoc.injector.BaseScopeInjector;
import jodd.madvoc.injector.Injector;
import jodd.madvoc.injector.Target;
import jodd.util.StringUtil;

public class ActionPathMacroInjector
extends BaseScopeInjector
implements Injector {
    public ActionPathMacroInjector(ScopeDataResolver scopeDataResolver) {
        super(ScopeType.REQUEST, scopeDataResolver);
        this.silent = true;
    }

    @Override
    public void inject(ActionRequest actionRequest) {
        ActionConfig config = actionRequest.getActionConfig();
        ActionConfigSet set = config.getActionConfigSet();
        if (set.actionPathMacros == null) {
            return;
        }
        ScopeData[] injectData = this.lookupScopeData(actionRequest);
        if (injectData == null) {
            return;
        }
        Target[] targets = actionRequest.getTargets();
        String[] names = set.actionPathMacros.getNames();
        String[] values = set.actionPathMacros.extract(actionRequest.getActionPath());
        for (int ndx = 0; ndx < values.length; ++ndx) {
            String value = values[ndx];
            if (StringUtil.isEmpty(value)) continue;
            String macroName = names[ndx];
            for (int i = 0; i < targets.length; ++i) {
                ScopeData.In[] scopes;
                Target target = targets[i];
                if (injectData[i] == null || (scopes = injectData[i].in) == null) continue;
                for (ScopeData.In in : scopes) {
                    String name = this.getMatchedPropertyName(in, macroName);
                    if (name == null) continue;
                    this.setTargetProperty(target, name, value);
                }
            }
        }
    }
}

