/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite;

import jodd.petite.CtorInjectionPoint;
import jodd.petite.DestroyMethodPoint;
import jodd.petite.InitMethodPoint;
import jodd.petite.MethodInjectionPoint;
import jodd.petite.PetiteException;
import jodd.petite.PropertyInjectionPoint;
import jodd.petite.SetInjectionPoint;
import jodd.petite.WiringMode;
import jodd.petite.scope.Scope;
import jodd.util.ArraysUtil;

public class BeanDefinition {
    protected final String name;
    protected final Class type;
    protected final Scope scope;
    protected final WiringMode wiringMode;
    protected CtorInjectionPoint ctor;
    protected PropertyInjectionPoint[] properties;
    protected SetInjectionPoint[] sets;
    protected MethodInjectionPoint[] methods;
    protected InitMethodPoint[] initMethods;
    protected DestroyMethodPoint[] destroyMethods;
    protected String[] params;

    public BeanDefinition(String name, Class type, Scope scope, WiringMode wiringMode) {
        this.name = name;
        this.type = type;
        this.scope = scope;
        this.wiringMode = wiringMode;
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public Class<? extends Scope> getScope() {
        if (this.scope == null) {
            return null;
        }
        return this.scope.getClass();
    }

    public WiringMode getWiringMode() {
        return this.wiringMode;
    }

    public CtorInjectionPoint getCtorInjectionPoint() {
        return this.ctor;
    }

    public PropertyInjectionPoint[] getPropertyInjectionPoints() {
        return this.properties;
    }

    public SetInjectionPoint[] getSetInjectionPoints() {
        return this.sets;
    }

    public MethodInjectionPoint[] getMethodInjectionPoints() {
        return this.methods;
    }

    public InitMethodPoint[] getInitMethodPoints() {
        return this.initMethods;
    }

    public DestroyMethodPoint[] getDestroyMethodPoints() {
        return this.destroyMethods;
    }

    public String[] getParams() {
        return this.params;
    }

    protected Object scopeLookup() {
        if (this.scope == null) {
            throw new PetiteException("Scope not defined");
        }
        return this.scope.lookup(this.name);
    }

    protected void scopeRegister(Object object) {
        if (this.scope != null) {
            this.scope.register(this, object);
        }
    }

    protected void scopeRemove() {
        this.scope.remove(this.name);
    }

    protected void addPropertyInjectionPoint(PropertyInjectionPoint pip) {
        if (this.properties == null) {
            this.properties = new PropertyInjectionPoint[1];
            this.properties[0] = pip;
        } else {
            this.properties = ArraysUtil.append(this.properties, pip);
        }
    }

    protected void addSetInjectionPoint(SetInjectionPoint sip) {
        if (this.sets == null) {
            this.sets = new SetInjectionPoint[1];
            this.sets[0] = sip;
        } else {
            this.sets = ArraysUtil.append(this.sets, sip);
        }
    }

    protected void addMethodInjectionPoint(MethodInjectionPoint mip) {
        if (this.methods == null) {
            this.methods = new MethodInjectionPoint[1];
            this.methods[0] = mip;
        } else {
            this.methods = ArraysUtil.append(this.methods, mip);
        }
    }

    protected void addInitMethodPoints(InitMethodPoint[] methods) {
        this.initMethods = this.initMethods == null ? methods : ArraysUtil.join(this.initMethods, methods);
    }

    protected void addDestroyMethodPoints(DestroyMethodPoint[] methods) {
        this.destroyMethods = this.destroyMethods == null ? methods : ArraysUtil.join(this.destroyMethods, methods);
    }

    public String toString() {
        return "BeanDefinition{name='" + this.name + '\'' + ", type=" + this.type + ", scope=" + this.scope + ", wiring= " + (Object)((Object)this.wiringMode) + '}';
    }
}

