/*
 * Decompiled with CFR 0.152.
 */
package jodd.props;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import jodd.props.PropsEntry;
import jodd.util.StringTemplateParser;
import jodd.util.StringUtil;
import jodd.util.Wildcard;

public class PropsData
implements Cloneable {
    private static final int MAX_INNER_MACROS = 100;
    private static final String APPEND_SEPARATOR = ",";
    protected final HashMap<String, PropsEntry> baseProperties;
    protected final HashMap<String, Map<String, PropsEntry>> profileProperties;
    protected PropsEntry first;
    protected PropsEntry last;
    protected boolean appendDuplicateProps;
    protected boolean ignoreMissingMacros;
    protected boolean skipEmptyProps = true;

    public PropsData() {
        this(new HashMap<String, PropsEntry>(), new HashMap<String, Map<String, PropsEntry>>());
    }

    protected PropsData(HashMap<String, PropsEntry> properties, HashMap<String, Map<String, PropsEntry>> profiles) {
        this.baseProperties = properties;
        this.profileProperties = profiles;
    }

    public PropsData clone() {
        HashMap<String, PropsEntry> newBase = new HashMap<String, PropsEntry>();
        HashMap<String, Map<String, PropsEntry>> newProfiles = new HashMap<String, Map<String, PropsEntry>>();
        newBase.putAll(this.baseProperties);
        for (Map.Entry<String, Map<String, PropsEntry>> entry : this.profileProperties.entrySet()) {
            HashMap<String, PropsEntry> map = new HashMap<String, PropsEntry>(entry.getValue().size());
            map.putAll(entry.getValue());
            newProfiles.put(entry.getKey(), map);
        }
        PropsData pd = new PropsData(newBase, newProfiles);
        pd.appendDuplicateProps = this.appendDuplicateProps;
        pd.ignoreMissingMacros = this.ignoreMissingMacros;
        pd.skipEmptyProps = this.skipEmptyProps;
        return pd;
    }

    protected void put(String profile, Map<String, PropsEntry> map, String key, String value, boolean append) {
        PropsEntry pv;
        String realValue = value;
        if ((append || this.appendDuplicateProps) && (pv = map.get(key)) != null) {
            realValue = pv.value + APPEND_SEPARATOR + realValue;
        }
        PropsEntry propsEntry = new PropsEntry(key, realValue, profile, this);
        if (this.first == null) {
            this.first = propsEntry;
        } else {
            this.last.next = propsEntry;
        }
        this.last = propsEntry;
        map.put(key, propsEntry);
    }

    public int countBaseProperties() {
        return this.baseProperties.size();
    }

    public void putBaseProperty(String key, String value, boolean append) {
        this.put(null, this.baseProperties, key, value, append);
    }

    public PropsEntry getBaseProperty(String key) {
        return this.baseProperties.get(key);
    }

    public int countProfileProperties() {
        HashSet<String> profileKeys = new HashSet<String>();
        for (Map<String, PropsEntry> map : this.profileProperties.values()) {
            for (String key : map.keySet()) {
                if (this.baseProperties.containsKey(key)) continue;
                profileKeys.add(key);
            }
        }
        return profileKeys.size();
    }

    public void putProfileProperty(String key, String value, String profile, boolean append) {
        Map<String, PropsEntry> map = this.profileProperties.get(profile);
        if (map == null) {
            map = new HashMap<String, PropsEntry>();
            this.profileProperties.put(profile, map);
        }
        this.put(profile, map, key, value, append);
    }

    public PropsEntry getProfileProperty(String profile, String key) {
        Map<String, PropsEntry> profileMap = this.profileProperties.get(profile);
        if (profileMap == null) {
            return null;
        }
        return profileMap.get(key);
    }

    protected String lookupValue(String key, String ... profiles) {
        PropsEntry value;
        if (profiles != null) {
            block0: for (String profile : profiles) {
                if (profile == null) continue;
                PropsEntry value2;
                Map<String, PropsEntry> profileMap;
                while ((profileMap = this.profileProperties.get(profile)) == null || (value2 = profileMap.get(key)) == null) {
                    int ndx = profile.lastIndexOf(46);
                    if (ndx == -1) continue block0;
                    profile = profile.substring(0, ndx);
                }
                return value2.getValue(profiles);
            }
        }
        if ((value = this.getBaseProperty(key)) == null) {
            return null;
        }
        return value.getValue(profiles);
    }

    public String resolveMacros(String value, final String ... profiles) {
        String newValue;
        StringTemplateParser stringTemplateParser = new StringTemplateParser();
        stringTemplateParser.setResolveEscapes(false);
        if (!this.ignoreMissingMacros) {
            stringTemplateParser.setReplaceMissingKey(false);
        } else {
            stringTemplateParser.setReplaceMissingKey(true);
            stringTemplateParser.setMissingKeyReplacement("");
        }
        StringTemplateParser.MacroResolver macroResolver = new StringTemplateParser.MacroResolver(){

            @Override
            public String resolve(String macroName) {
                String[] lookupProfiles = profiles;
                int leftIndex = macroName.indexOf(60);
                if (leftIndex != -1) {
                    int rightIndex = macroName.indexOf(62);
                    String profiles2 = macroName.substring(leftIndex + 1, rightIndex);
                    macroName = macroName.substring(0, leftIndex).concat(macroName.substring(rightIndex + 1));
                    lookupProfiles = StringUtil.splitc(profiles2, ',');
                    StringUtil.trimAll(lookupProfiles);
                }
                return PropsData.this.lookupValue(macroName, lookupProfiles);
            }
        };
        int loopCount = 0;
        while (loopCount++ < 100 && !(newValue = stringTemplateParser.parse(value, macroResolver)).equals(value)) {
            if (this.skipEmptyProps && newValue.length() == 0) {
                return null;
            }
            value = newValue;
        }
        return value;
    }

    public Map extract(Map target, String[] profiles, String[] wildcardPatterns, String prefix) {
        if (target == null) {
            target = new HashMap();
        }
        if (prefix != null && !StringUtil.endsWithChar(prefix, '.')) {
            prefix = prefix + ".";
        }
        if (profiles != null) {
            block0: for (String profile : profiles) {
                while (true) {
                    int ndx;
                    Map<String, PropsEntry> map;
                    if ((map = this.profileProperties.get(profile)) != null) {
                        this.extractMap(target, map, profiles, wildcardPatterns, prefix);
                    }
                    if ((ndx = profile.indexOf(46)) == -1) continue block0;
                    profile = profile.substring(0, ndx);
                }
            }
        }
        this.extractMap(target, this.baseProperties, profiles, wildcardPatterns, prefix);
        return target;
    }

    protected void extractMap(Map target, Map<String, PropsEntry> map, String[] profiles, String[] wildcardPatterns, String prefix) {
        for (Map.Entry<String, PropsEntry> entry : map.entrySet()) {
            String key = entry.getKey();
            if (wildcardPatterns != null && Wildcard.matchOne(key, wildcardPatterns) == -1) continue;
            if (prefix != null) {
                if (!key.startsWith(prefix)) continue;
                key = key.substring(prefix.length());
            }
            if (target.containsKey(key)) continue;
            target.put(key, entry.getValue().getValue(profiles));
        }
    }
}

