/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.io.Serializable;
import java.util.Comparator;
import jodd.util.CharUtil;

public class NaturalOrderComparator<T>
implements Comparator<T>,
Serializable {
    private static final char[] ACCENT_CHARS = new char[]{'\u00c0', 'A', '\u00c1', 'A', '\u00c2', 'A', '\u00c3', 'A', '\u00c4', 'A', '\u00c5', 'A', '\u00e0', 'a', '\u00e1', 'a', '\u00e2', 'a', '\u00e3', 'a', '\u00e4', 'a', '\u00e5', 'a', '\u00c7', 'C', '\u00e7', 'c', '\u00c8', 'E', '\u00c9', 'E', '\u00ca', 'E', '\u00cb', 'E', '\u00e8', 'e', '\u00e9', 'e', '\u00ea', 'e', '\u00eb', 'e', '\u00cc', 'I', '\u00cd', 'I', '\u00ce', 'I', '\u00cf', 'I', '\u00ec', 'i', '\u00ed', 'i', '\u00ee', 'i', '\u00ef', 'i', '\u00d2', 'O', '\u00d3', 'O', '\u00d4', 'O', '\u00d5', 'O', '\u00d6', 'O', '\u00d8', 'O', '\u00f2', 'o', '\u00f3', 'o', '\u00f4', 'o', '\u00f5', 'o', '\u00f6', 'o', '\u00f8', 'o', '\u00d1', 'N', '\u00f1', 'n', '\u00d9', 'U', '\u00da', 'U', '\u00db', 'U', '\u00dc', 'U', '\u00f9', 'u', '\u00fa', 'u', '\u00fb', 'u', '\u00fc', 'u', '\u00dd', 'Y', '\u00ff', 'y', '\u00fd', 'y'};
    protected final boolean ignoreCase;
    protected final boolean ignoreAccents;

    public NaturalOrderComparator() {
        this(false, true);
    }

    public NaturalOrderComparator(boolean ignoreCase, boolean ignoreAccents) {
        this.ignoreCase = ignoreCase;
        this.ignoreAccents = ignoreAccents;
    }

    protected int compareDigits(String str1, int ndx1, String str2, int ndx2) {
        int bias = 0;
        while (true) {
            char char1 = NaturalOrderComparator.charAt(str1, ndx1);
            char char2 = NaturalOrderComparator.charAt(str2, ndx2);
            boolean isDigitChar1 = CharUtil.isDigit(char1);
            boolean isDigitChar2 = CharUtil.isDigit(char2);
            if (!isDigitChar1 && !isDigitChar2) {
                return bias;
            }
            if (!isDigitChar1) {
                return -1;
            }
            if (!isDigitChar2) {
                return 1;
            }
            if (char1 < char2) {
                if (bias == 0) {
                    bias = -1;
                }
            } else if (char1 > char2) {
                if (bias == 0) {
                    bias = 1;
                }
            } else if (char1 == '\u0000' && char2 == '\u0000') {
                return bias;
            }
            ++ndx1;
            ++ndx2;
        }
    }

    @Override
    public int compare(T o1, T o2) {
        String str1 = o1.toString();
        String str2 = o2.toString();
        int ndx1 = 0;
        int ndx2 = 0;
        int zerosDelta = 0;
        int lastAllZerosResult = 0;
        while (true) {
            int zeroCount2 = 0;
            int zeroCount1 = 0;
            char char1 = NaturalOrderComparator.charAt(str1, ndx1);
            char char2 = NaturalOrderComparator.charAt(str2, ndx2);
            while (Character.isSpaceChar(char1) || char1 == '0') {
                zeroCount1 = char1 == '0' ? ++zeroCount1 : 0;
                char1 = NaturalOrderComparator.charAt(str1, ++ndx1);
            }
            while (Character.isSpaceChar(char2) || char2 == '0') {
                zeroCount2 = char2 == '0' ? ++zeroCount2 : 0;
                char2 = NaturalOrderComparator.charAt(str2, ++ndx2);
            }
            if (zeroCount1 > 0 || zeroCount2 > 0) {
                zerosDelta = zeroCount1 - zeroCount2;
            }
            boolean isDigitChar1 = CharUtil.isDigit(char1);
            boolean isDigitChar2 = CharUtil.isDigit(char2);
            if (isDigitChar1 && isDigitChar2) {
                int result = this.compareDigits(str1, ndx1, str2, ndx2);
                if (result != 0) {
                    return result;
                }
                if (zeroCount1 != zeroCount2) {
                    return zerosDelta;
                }
            }
            if (char1 == '\u0000' && char2 == '\u0000') {
                if (lastAllZerosResult == 0) {
                    return zerosDelta;
                }
                return lastAllZerosResult;
            }
            if ((isDigitChar1 || isDigitChar2) && zeroCount1 > 0 && zeroCount2 > 0 && zeroCount1 != zeroCount2) {
                return -zerosDelta;
            }
            if (zerosDelta != 0) {
                if (zeroCount1 > 0 && zeroCount2 > 0) {
                    lastAllZerosResult = zerosDelta;
                } else {
                    if (zeroCount1 > 0) {
                        if (char2 > '0') {
                            return -zerosDelta;
                        }
                        return zerosDelta;
                    }
                    if (zeroCount2 > 0) {
                        if (char1 > '0') {
                            return -zerosDelta;
                        }
                        return zerosDelta;
                    }
                    return 0;
                }
            }
            if (this.ignoreCase) {
                char1 = Character.toLowerCase(char1);
                char2 = Character.toLowerCase(char2);
            }
            if (this.ignoreAccents) {
                char1 = this.fixAccent(char1);
                char2 = this.fixAccent(char2);
            }
            if (char1 < char2) {
                return -1;
            }
            if (char1 > char2) {
                return 1;
            }
            ++ndx1;
            ++ndx2;
        }
    }

    private char fixAccent(char c) {
        for (int i = 0; i < ACCENT_CHARS.length; i += 2) {
            char accentChar = ACCENT_CHARS[i];
            if (accentChar != c) continue;
            return ACCENT_CHARS[i + 1];
        }
        return c;
    }

    private static char charAt(String string, int ndx) {
        if (ndx >= string.length()) {
            return '\u0000';
        }
        return string.charAt(ndx);
    }
}

