/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.type;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import jodd.cache.TypeCache;
import jodd.db.DbSqlException;
import jodd.db.type.BigDecimalSqlType;
import jodd.db.type.BigIntegerSqlType;
import jodd.db.type.BlobSqlType;
import jodd.db.type.BooleanSqlType;
import jodd.db.type.ByteArraySqlType;
import jodd.db.type.ByteSqlType;
import jodd.db.type.CharacterSqlType;
import jodd.db.type.ClobSqlType;
import jodd.db.type.DateSqlType;
import jodd.db.type.DoubleSqlType;
import jodd.db.type.FloatSqlType;
import jodd.db.type.IntegerSqlType;
import jodd.db.type.JulianDateSqlType;
import jodd.db.type.LocalDateSqlType;
import jodd.db.type.LocalDateTimeSqlType;
import jodd.db.type.LocalTimeSqlType;
import jodd.db.type.LongSqlType;
import jodd.db.type.ShortSqlType;
import jodd.db.type.SqlArraySqlType;
import jodd.db.type.SqlDateSqlType;
import jodd.db.type.SqlRefSqlType;
import jodd.db.type.SqlType;
import jodd.db.type.StringSqlType;
import jodd.db.type.TimeSqlType;
import jodd.db.type.TimestampSqlType;
import jodd.db.type.URLSqlType;
import jodd.mutable.MutableBoolean;
import jodd.mutable.MutableByte;
import jodd.mutable.MutableDouble;
import jodd.mutable.MutableFloat;
import jodd.mutable.MutableInteger;
import jodd.mutable.MutableLong;
import jodd.mutable.MutableShort;
import jodd.time.JulianDate;
import jodd.util.ClassUtil;

public class SqlTypeManager {
    private static final SqlTypeManager SQL_TYPE_MANAGER = new SqlTypeManager();
    private TypeCache<SqlType> types = TypeCache.createDefault();
    private TypeCache<SqlType> sqlTypes = TypeCache.createDefault();

    public static SqlTypeManager get() {
        return SQL_TYPE_MANAGER;
    }

    public SqlTypeManager() {
        this.registerDefaults();
    }

    public void unregisterAll() {
        this.types.clear();
    }

    public void registerDefaults() {
        this.register(Integer.class, IntegerSqlType.class);
        this.register(Integer.TYPE, IntegerSqlType.class);
        this.register(MutableInteger.class, IntegerSqlType.class);
        this.register(Float.class, FloatSqlType.class);
        this.register(Float.TYPE, FloatSqlType.class);
        this.register(MutableFloat.class, FloatSqlType.class);
        this.register(Double.class, DoubleSqlType.class);
        this.register(Double.TYPE, DoubleSqlType.class);
        this.register(MutableDouble.class, DoubleSqlType.class);
        this.register(Byte.class, ByteSqlType.class);
        this.register(Byte.TYPE, ByteSqlType.class);
        this.register(MutableByte.class, ByteSqlType.class);
        this.register(Boolean.class, BooleanSqlType.class);
        this.register(Boolean.TYPE, BooleanSqlType.class);
        this.register(MutableBoolean.class, BooleanSqlType.class);
        this.register(Long.class, LongSqlType.class);
        this.register(Long.TYPE, LongSqlType.class);
        this.register(MutableLong.class, LongSqlType.class);
        this.register(Short.class, ShortSqlType.class);
        this.register(Short.TYPE, ShortSqlType.class);
        this.register(MutableShort.class, ShortSqlType.class);
        this.register(Character.class, CharacterSqlType.class);
        this.register(Character.TYPE, CharacterSqlType.class);
        this.register(BigDecimal.class, BigDecimalSqlType.class);
        this.register(BigInteger.class, BigIntegerSqlType.class);
        this.register(String.class, StringSqlType.class);
        this.register(LocalDateTime.class, LocalDateTimeSqlType.class);
        this.register(LocalDate.class, LocalDateSqlType.class);
        this.register(LocalTime.class, LocalTimeSqlType.class);
        this.register(Date.class, SqlDateSqlType.class);
        this.register(Timestamp.class, TimestampSqlType.class);
        this.register(Time.class, TimeSqlType.class);
        this.register(java.util.Date.class, DateSqlType.class);
        this.register(JulianDate.class, JulianDateSqlType.class);
        this.register(byte[].class, ByteArraySqlType.class);
        this.register(URL.class, URLSqlType.class);
        this.register(Blob.class, BlobSqlType.class);
        this.register(Clob.class, ClobSqlType.class);
        this.register(Array.class, SqlArraySqlType.class);
        this.register(Ref.class, SqlRefSqlType.class);
    }

    public void register(Class type, Class<? extends SqlType> sqlTypeClass) {
        this.types.put(type, this.lookupSqlType(sqlTypeClass));
    }

    public void unregister(Class type) {
        this.types.remove(type);
    }

    public SqlType lookup(Class clazz) {
        for (Class x = clazz; x != null; x = x.getSuperclass()) {
            Class<?>[] interfaces;
            SqlType sqlType = this.types.get(clazz);
            if (sqlType != null) {
                return sqlType;
            }
            for (Class<?> i : interfaces = x.getInterfaces()) {
                sqlType = this.types.get(i);
                if (sqlType == null) continue;
                return sqlType;
            }
        }
        return null;
    }

    public SqlType lookupSqlType(Class<? extends SqlType> sqlTypeClass) {
        SqlType sqlType = this.sqlTypes.get(sqlTypeClass);
        if (sqlType == null) {
            try {
                sqlType = ClassUtil.newInstance(sqlTypeClass);
            }
            catch (Exception ex) {
                throw new DbSqlException("SQL type not found: " + sqlTypeClass.getSimpleName(), ex);
            }
            this.sqlTypes.put(sqlTypeClass, sqlType);
        }
        return sqlType;
    }
}

