/*
 * Decompiled with CFR 0.152.
 */
package jodd.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import jodd.http.Buffer;
import jodd.http.Cookie;
import jodd.http.HttpBase;
import jodd.http.HttpConnection;
import jodd.http.HttpException;
import jodd.http.HttpRequest;
import jodd.io.StreamUtil;

public class HttpResponse
extends HttpBase<HttpResponse> {
    protected int statusCode;
    protected String statusPhrase;
    protected HttpRequest httpRequest;

    public int statusCode() {
        return this.statusCode;
    }

    public HttpResponse statusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public String statusPhrase() {
        return this.statusPhrase;
    }

    public HttpResponse statusPhrase(String statusPhrase) {
        this.statusPhrase = statusPhrase;
        return this;
    }

    public String location() {
        String location = this.header("location");
        if (location == null) {
            return null;
        }
        if (location.startsWith("/")) {
            location = this.getHttpRequest().hostUrl() + location;
        }
        return location;
    }

    public Cookie[] cookies() {
        List<String> newCookies = this.headers("set-cookie");
        if (newCookies == null) {
            return new Cookie[0];
        }
        ArrayList<Cookie> cookieList = new ArrayList<Cookie>(newCookies.size());
        for (String cookieValue : newCookies) {
            try {
                Cookie cookie = new Cookie(cookieValue);
                cookieList.add(cookie);
            }
            catch (Exception exception) {}
        }
        return cookieList.toArray(new Cookie[0]);
    }

    public HttpResponse unzip() {
        String contentEncoding = this.contentEncoding();
        if (contentEncoding != null && this.contentEncoding().equals("gzip") && this.body != null) {
            this.headerRemove("Content-Encoding");
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(this.body.getBytes("ISO-8859-1"));
                GZIPInputStream gzipInputStream = new GZIPInputStream(in);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                StreamUtil.copy((InputStream)gzipInputStream, out);
                this.body(out.toString("ISO-8859-1"));
            }
            catch (IOException ioex) {
                throw new HttpException(ioex);
            }
        }
        return this;
    }

    @Override
    protected Buffer buffer(boolean fullResponse) {
        Buffer formBuffer = this.formBuffer();
        Buffer response = new Buffer();
        response.append(this.httpVersion).append(" ").append(this.statusCode).append(" ").append(this.statusPhrase).append("\r\n");
        this.populateHeaderAndBody(response, formBuffer, fullResponse);
        return response;
    }

    public static HttpResponse readFrom(InputStream in) {
        String line;
        InputStreamReader inputStreamReader;
        try {
            inputStreamReader = new InputStreamReader(in, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unee) {
            throw new HttpException(unee);
        }
        BufferedReader reader = new BufferedReader(inputStreamReader);
        HttpResponse httpResponse = new HttpResponse();
        try {
            line = reader.readLine();
        }
        catch (IOException ioex) {
            throw new HttpException(ioex);
        }
        if (line != null) {
            int ndx2;
            int ndx = (line = line.trim()).indexOf(32);
            if (ndx > -1) {
                httpResponse.httpVersion(line.substring(0, ndx));
                ndx2 = line.indexOf(32, ndx + 1);
            } else {
                httpResponse.httpVersion("HTTP/1.1");
                ndx2 = -1;
                ndx = 0;
            }
            if (ndx2 == -1) {
                ndx2 = line.length();
            }
            try {
                httpResponse.statusCode(Integer.parseInt(line.substring(ndx, ndx2).trim()));
            }
            catch (NumberFormatException nfex) {
                httpResponse.statusCode(-1);
            }
            httpResponse.statusPhrase(line.substring(ndx2).trim());
        }
        httpResponse.readHeaders(reader);
        httpResponse.readBody(reader);
        return httpResponse;
    }

    void assignHttpRequest(HttpRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public HttpResponse close() {
        HttpConnection httpConnection = this.httpRequest.httpConnection;
        if (httpConnection != null) {
            httpConnection.close();
            this.httpRequest.httpConnection = null;
        }
        return this;
    }
}

