/*
 * Decompiled with CFR 0.152.
 */
package jodd.json;

import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class LazyMap
extends AbstractMap {
    private LinkedHashMap map;
    private int size;
    private Object[] keys = new Object[5];
    private Object[] values = new Object[5];

    @Override
    public Object put(Object key, Object value) {
        if (this.map == null) {
            this.keys[this.size] = key;
            this.values[this.size] = value;
            ++this.size;
            if (this.size == this.keys.length) {
                this.keys = LazyMap.grow(this.keys);
                this.values = LazyMap.grow(this.values);
            }
            return null;
        }
        return this.map.put(key, value);
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        this.buildIfNeeded();
        return this.map.entrySet();
    }

    @Override
    public int size() {
        return this.map == null ? this.size : this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map == null ? this.size == 0 : this.map.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.map == null && this.size < 5) {
            for (int index = 0; index < this.size; ++index) {
                if (!this.values[index].equals(value)) continue;
                return true;
            }
            return false;
        }
        this.buildIfNeeded();
        return this.map.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.map == null && this.size < 5) {
            for (int index = 0; index < this.size; ++index) {
                if (!this.keys[index].equals(key)) continue;
                return true;
            }
            return false;
        }
        this.buildIfNeeded();
        return this.map.containsKey(key);
    }

    @Override
    public Object get(Object key) {
        this.buildIfNeeded();
        return this.map.get(key);
    }

    private void buildIfNeeded() {
        if (this.map == null) {
            this.map = new LinkedHashMap(this.size, 0.01f);
            for (int index = 0; index < this.size; ++index) {
                Object value = this.values[index];
                if (value instanceof Supplier) {
                    value = ((Supplier)value).get();
                }
                this.map.put(this.keys[index], value);
            }
            this.keys = null;
            this.values = null;
        }
    }

    @Override
    public Object remove(Object key) {
        this.buildIfNeeded();
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map m) {
        this.buildIfNeeded();
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        if (this.map == null) {
            this.size = 0;
        } else {
            this.map.clear();
        }
    }

    @Override
    public Set keySet() {
        return this.map == null ? LazyMap.set(this.size, this.keys) : this.map.keySet();
    }

    @Override
    public Collection values() {
        return this.map == null ? Arrays.asList(this.values) : this.map.values();
    }

    @Override
    public boolean equals(Object o) {
        this.buildIfNeeded();
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        this.buildIfNeeded();
        return this.map.hashCode();
    }

    @Override
    public String toString() {
        this.buildIfNeeded();
        return this.map.toString();
    }

    @Override
    protected Object clone() {
        return this.map == null ? null : this.map.clone();
    }

    private static <V> Set<V> set(int size, V ... array) {
        int index = 0;
        HashSet<V> set = new HashSet<V>();
        for (V v : array) {
            set.add(v);
            if (++index == size) break;
        }
        return set;
    }

    private static <V> V[] grow(V[] array) {
        Object newArray = Array.newInstance(array.getClass().getComponentType(), array.length * 2);
        System.arraycopy(array, 0, newArray, 0, array.length);
        return (Object[])newArray;
    }

    private static <V> List<V> list(V ... array) {
        int length = array.length;
        ArrayList<Object> list = new ArrayList<Object>();
        for (int index = 0; index < length; ++index) {
            list.add(Array.get(array, index));
        }
        return list;
    }
}

