/*
 * Decompiled with CFR 0.152.
 */
package jodd.asm;

import jodd.asm7.MethodVisitor;
import jodd.mutable.MutableInteger;

public class AsmUtil {
    public static final int TYPE_BYTE = 66;
    public static final int TYPE_CHAR = 67;
    public static final int TYPE_DOUBLE = 68;
    public static final int TYPE_FLOAT = 70;
    public static final int TYPE_INT = 73;
    public static final int TYPE_LONG = 74;
    public static final int TYPE_REFERENCE = 76;
    public static final int TYPE_SHORT = 83;
    public static final int TYPE_BOOLEAN = 90;
    public static final int TYPE_VOID = 86;
    public static final int TYPE_ARRAY = 91;
    public static final int TYPE_ANNOTATION = 64;
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SUPER = 32;
    public static final int ACC_SYNCHRONIZED = 32;
    public static final int ACC_VOLATILE = 64;
    public static final int ACC_BRIDGE = 64;
    public static final int ACC_VARARGS = 128;
    public static final int ACC_TRANSIENT = 128;
    public static final int ACC_NATIVE = 256;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;
    public static final int ACC_STRICT = 2048;
    public static final int ACC_SYNTHETIC = 4096;
    public static final int ACC_ANNOTATION = 8192;
    public static final int ACC_ENUM = 16384;
    public static final String SIGNATURE_JAVA_LANG_OBJECT = "java/lang/Object";
    public static final String SIGNATURE_JAVA_LANG_CLASS = "java/lang/Class";
    public static final String SIGNATURE_JAVA_LANG_BYTE = "java/lang/Byte";
    public static final String SIGNATURE_JAVA_LANG_CHARACTER = "java/lang/Character";
    public static final String SIGNATURE_JAVA_LANG_SHORT = "java/lang/Short";
    public static final String SIGNATURE_JAVA_LANG_INTEGER = "java/lang/Integer";
    public static final String SIGNATURE_JAVA_LANG_BOOLEAN = "java/lang/Boolean";
    public static final String SIGNATURE_JAVA_LANG_LONG = "java/lang/Long";
    public static final String SIGNATURE_JAVA_LANG_FLOAT = "java/lang/Float";
    public static final String SIGNATURE_JAVA_LANG_DOUBLE = "java/lang/Double";
    public static final String SIGNATURE_JAVA_LANG_VOID = "java/lang/Void";
    public static final String L_SIGNATURE_JAVA_LANG_OBJECT = "Ljava/lang/Object;";
    public static final String L_SIGNATURE_JAVA_LANG_STRING = "Ljava/lang/String;";
    public static final String L_SIGNATURE_JAVA_LANG_CLASS = "Ljava/lang/Class;";
    private static final String INVALID_BASE_TYPE = "Invalid base type: ";
    private static final String INVALID_TYPE_DESCRIPTION = "Invalid type description: ";

    public static String typedesc2ClassName(String desc) {
        String className = desc;
        switch (desc.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                if (desc.length() == 1) break;
                throw new IllegalArgumentException(INVALID_BASE_TYPE + desc);
            }
            case 'L': {
                className = className.substring(1, className.length() - 1);
                break;
            }
            case '[': {
                className = className.replace('/', '.');
                break;
            }
            default: {
                throw new IllegalArgumentException(INVALID_TYPE_DESCRIPTION + desc);
            }
        }
        return className;
    }

    public static String typeref2Name(String desc) {
        if (desc.charAt(0) != 'L') {
            throw new IllegalArgumentException(INVALID_TYPE_DESCRIPTION + desc);
        }
        String name = desc.substring(1, desc.length() - 1);
        return name.replace('/', '.');
    }

    public static char typeNameToOpcode(String typeName) {
        switch (typeName) {
            case "byte": {
                return 'B';
            }
            case "char": {
                return 'C';
            }
            case "double": {
                return 'D';
            }
            case "float": {
                return 'F';
            }
            case "int": {
                return 'I';
            }
            case "long": {
                return 'J';
            }
            case "short": {
                return 'S';
            }
            case "boolean": {
                return 'Z';
            }
            case "void": {
                return 'V';
            }
        }
        return 'L';
    }

    public static String typedescToSignature(String desc) {
        return AsmUtil.typedescToSignature(desc, new MutableInteger());
    }

    public static String typedescToSignature(String desc, MutableInteger from) {
        int fromIndex = from.get();
        ++from.value;
        switch (desc.charAt(fromIndex)) {
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'D': {
                return "double";
            }
            case 'F': {
                return "float";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'S': {
                return "short";
            }
            case 'Z': {
                return "boolean";
            }
            case 'V': {
                return "void";
            }
            case 'L': {
                int index = desc.indexOf(59, fromIndex);
                if (index < 0) {
                    throw new IllegalArgumentException(INVALID_TYPE_DESCRIPTION + desc);
                }
                from.set(index + 1);
                String str = desc.substring(fromIndex + 1, index);
                return str.replace('/', '.');
            }
            case 'T': {
                return desc.substring(from.value);
            }
            case '[': {
                StringBuilder brackets = new StringBuilder();
                int n = fromIndex;
                while (desc.charAt(n) == '[') {
                    brackets.append("[]");
                    ++n;
                }
                from.value = n;
                String type = AsmUtil.typedescToSignature(desc, from);
                return type + brackets;
            }
        }
        if (from.value == 0) {
            throw new IllegalArgumentException(INVALID_TYPE_DESCRIPTION + desc);
        }
        return desc.substring(from.value);
    }

    public static String typeToSignature(String className) {
        return className.replace('.', '/');
    }

    public static String typeToSignature(Class type) {
        return AsmUtil.typeToSignature(type.getName());
    }

    public static String typeToTyperef(Class type) {
        if (!type.isArray()) {
            if (!type.isPrimitive()) {
                return 'L' + AsmUtil.typeToSignature(type) + ';';
            }
            if (type == Integer.TYPE) {
                return "I";
            }
            if (type == Long.TYPE) {
                return "J";
            }
            if (type == Boolean.TYPE) {
                return "Z";
            }
            if (type == Double.TYPE) {
                return "D";
            }
            if (type == Float.TYPE) {
                return "F";
            }
            if (type == Short.TYPE) {
                return "S";
            }
            if (type == Void.TYPE) {
                return "V";
            }
            if (type == Byte.TYPE) {
                return "B";
            }
            if (type == Character.TYPE) {
                return "C";
            }
        }
        return type.getName();
    }

    public static void intValue(MethodVisitor mv) {
        mv.visitTypeInsn(192, SIGNATURE_JAVA_LANG_INTEGER);
        mv.visitMethodInsn(182, SIGNATURE_JAVA_LANG_INTEGER, "intValue", "()I", false);
    }

    public static void longValue(MethodVisitor mv) {
        mv.visitTypeInsn(192, SIGNATURE_JAVA_LANG_LONG);
        mv.visitMethodInsn(182, SIGNATURE_JAVA_LANG_LONG, "longValue", "()J", false);
    }

    public static void floatValue(MethodVisitor mv) {
        mv.visitTypeInsn(192, SIGNATURE_JAVA_LANG_FLOAT);
        mv.visitMethodInsn(182, SIGNATURE_JAVA_LANG_FLOAT, "floatValue", "()F", false);
    }

    public static void doubleValue(MethodVisitor mv) {
        mv.visitTypeInsn(192, SIGNATURE_JAVA_LANG_DOUBLE);
        mv.visitMethodInsn(182, SIGNATURE_JAVA_LANG_DOUBLE, "doubleValue", "()D", false);
    }

    public static void byteValue(MethodVisitor mv) {
        mv.visitTypeInsn(192, SIGNATURE_JAVA_LANG_BYTE);
        mv.visitMethodInsn(182, SIGNATURE_JAVA_LANG_BYTE, "byteValue", "()B", false);
    }

    public static void shortValue(MethodVisitor mv) {
        mv.visitTypeInsn(192, SIGNATURE_JAVA_LANG_SHORT);
        mv.visitMethodInsn(182, SIGNATURE_JAVA_LANG_SHORT, "shortValue", "()S", false);
    }

    public static void booleanValue(MethodVisitor mv) {
        mv.visitTypeInsn(192, SIGNATURE_JAVA_LANG_BOOLEAN);
        mv.visitMethodInsn(182, SIGNATURE_JAVA_LANG_BOOLEAN, "booleanValue", "()Z", false);
    }

    public static void charValue(MethodVisitor mv) {
        mv.visitTypeInsn(192, SIGNATURE_JAVA_LANG_CHARACTER);
        mv.visitMethodInsn(182, SIGNATURE_JAVA_LANG_CHARACTER, "charValue", "()C", false);
    }

    public static void valueOfInteger(MethodVisitor mv) {
        mv.visitMethodInsn(184, SIGNATURE_JAVA_LANG_INTEGER, "valueOf", "(I)Ljava/lang/Integer;", false);
    }

    public static void valueOfLong(MethodVisitor mv) {
        mv.visitMethodInsn(184, SIGNATURE_JAVA_LANG_LONG, "valueOf", "(J)Ljava/lang/Long;", false);
    }

    public static void valueOfFloat(MethodVisitor mv) {
        mv.visitMethodInsn(184, SIGNATURE_JAVA_LANG_FLOAT, "valueOf", "(F)Ljava/lang/Float;", false);
    }

    public static void valueOfDouble(MethodVisitor mv) {
        mv.visitMethodInsn(184, SIGNATURE_JAVA_LANG_DOUBLE, "valueOf", "(D)Ljava/lang/Double;", false);
    }

    public static void valueOfByte(MethodVisitor mv) {
        mv.visitMethodInsn(184, SIGNATURE_JAVA_LANG_BYTE, "valueOf", "(B)Ljava/lang/Byte;", false);
    }

    public static void valueOfShort(MethodVisitor mv) {
        mv.visitMethodInsn(184, SIGNATURE_JAVA_LANG_SHORT, "valueOf", "(S)Ljava/lang/Short;", false);
    }

    public static void valueOfBoolean(MethodVisitor mv) {
        mv.visitMethodInsn(184, SIGNATURE_JAVA_LANG_BOOLEAN, "valueOf", "(Z)Ljava/lang/Boolean;", false);
    }

    public static void valueOfCharacter(MethodVisitor mv) {
        mv.visitMethodInsn(184, SIGNATURE_JAVA_LANG_CHARACTER, "valueOf", "(C)Ljava/lang/Character;", false);
    }
}

