/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.pool;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import jodd.db.DbSqlException;
import jodd.db.connection.ConnectionProvider;
import jodd.log.Logger;
import jodd.log.LoggerFactory;

public class CoreConnectionPool
implements Runnable,
ConnectionProvider {
    private static final Logger log = LoggerFactory.getLogger(CoreConnectionPool.class);
    private static final String DEFAULT_VALIDATION_QUERY = "select 1";
    private String driver;
    private String url;
    private String user;
    private String password;
    private int maxConnections = 10;
    private int minConnections = 5;
    private boolean waitIfBusy;
    private boolean validateConnection = true;
    private long validationTimeout = 18000000L;
    private String validationQuery;
    private ArrayList<ConnectionData> availableConnections;
    private ArrayList<ConnectionData> busyConnections;
    private boolean connectionPending;
    private boolean initialised;

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getMinConnections() {
        return this.minConnections;
    }

    public void setMinConnections(int minConnections) {
        this.minConnections = minConnections;
    }

    public boolean isWaitIfBusy() {
        return this.waitIfBusy;
    }

    public void setWaitIfBusy(boolean waitIfBusy) {
        this.waitIfBusy = waitIfBusy;
    }

    public long getValidationTimeout() {
        return this.validationTimeout;
    }

    public void setValidationTimeout(long validationTimeout) {
        this.validationTimeout = validationTimeout;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public void setDefaultValidationQuery() {
        this.validationQuery = DEFAULT_VALIDATION_QUERY;
    }

    public boolean isValidateConnection() {
        return this.validateConnection;
    }

    public void setValidateConnection(boolean validateConnection) {
        this.validateConnection = validateConnection;
    }

    @Override
    public synchronized void init() {
        if (this.initialised) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info("Core connection pool initialization");
        }
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException cnfex) {
            throw new DbSqlException("Database driver not found: " + this.driver, cnfex);
        }
        if (this.minConnections > this.maxConnections) {
            this.minConnections = this.maxConnections;
        }
        this.availableConnections = new ArrayList(this.maxConnections);
        this.busyConnections = new ArrayList(this.maxConnections);
        for (int i = 0; i < this.minConnections; ++i) {
            try {
                Connection conn = DriverManager.getConnection(this.url, this.user, this.password);
                this.availableConnections.add(new ConnectionData(conn));
                continue;
            }
            catch (SQLException sex) {
                throw new DbSqlException("No database connection", sex);
            }
        }
        this.initialised = true;
    }

    @Override
    public synchronized Connection getConnection() {
        if (this.availableConnections == null) {
            throw new DbSqlException("Connection pool is not initialized");
        }
        if (!this.availableConnections.isEmpty()) {
            int lastIndex = this.availableConnections.size() - 1;
            ConnectionData existingConnection = this.availableConnections.get(lastIndex);
            this.availableConnections.remove(lastIndex);
            long now = System.currentTimeMillis();
            boolean isValid = this.isConnectionValid(existingConnection, now);
            if (!isValid) {
                if (log.isDebugEnabled()) {
                    log.debug("Pooled connection not valid, resetting");
                }
                this.notifyAll();
                return this.getConnection();
            }
            if (log.isDebugEnabled()) {
                log.debug("Returning valid pooled connection");
            }
            this.busyConnections.add(existingConnection);
            existingConnection.lastUsed = now;
            return existingConnection.connection;
        }
        if (log.isDebugEnabled()) {
            log.debug("No more available connections");
        }
        if (this.availableConnections.size() + this.busyConnections.size() < this.maxConnections && !this.connectionPending) {
            this.makeBackgroundConnection();
        } else if (!this.waitIfBusy) {
            throw new DbSqlException("Connection limit reached: " + this.maxConnections);
        }
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isConnectionValid(ConnectionData connectionData, long now) {
        if (!this.validateConnection) {
            return true;
        }
        if (now < connectionData.lastUsed + this.validationTimeout) {
            return true;
        }
        Connection conn = connectionData.connection;
        if (this.validationQuery == null) {
            try {
                return !conn.isClosed();
            }
            catch (SQLException sex) {
                return false;
            }
        }
        boolean valid = true;
        Statement st = null;
        try {
            st = conn.createStatement();
            st.execute(this.validationQuery);
        }
        catch (SQLException sex) {
            valid = false;
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return valid;
    }

    private void makeBackgroundConnection() {
        this.connectionPending = true;
        Thread connectThread = new Thread(this);
        connectThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Connection connection = DriverManager.getConnection(this.url, this.user, this.password);
            CoreConnectionPool coreConnectionPool = this;
            synchronized (coreConnectionPool) {
                this.availableConnections.add(new ConnectionData(connection));
                this.connectionPending = false;
                this.notifyAll();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public synchronized void closeConnection(Connection connection) {
        ConnectionData connectionData = new ConnectionData(connection);
        this.busyConnections.remove(connectionData);
        this.availableConnections.add(connectionData);
        this.notifyAll();
    }

    @Override
    public synchronized void close() {
        if (log.isInfoEnabled()) {
            log.info("Core connection pool shutdown");
        }
        this.closeConnections(this.availableConnections);
        this.availableConnections = new ArrayList(this.maxConnections);
        this.closeConnections(this.busyConnections);
        this.busyConnections = new ArrayList(this.maxConnections);
    }

    private void closeConnections(ArrayList<ConnectionData> connections) {
        if (connections == null) {
            return;
        }
        try {
            for (ConnectionData connectionData : connections) {
                Connection connection = connectionData.connection;
                if (connection.isClosed()) continue;
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public synchronized SizeSnapshot getConnectionsCount() {
        return new SizeSnapshot(this.availableConnections.size(), this.busyConnections.size());
    }

    public static class SizeSnapshot {
        final int totalCount;
        final int availableCount;
        final int busyCount;

        SizeSnapshot(int availableCount, int busyCount) {
            this.totalCount = availableCount + busyCount;
            this.availableCount = availableCount;
            this.busyCount = busyCount;
        }

        public int getTotalCount() {
            return this.totalCount;
        }

        public int getAvailableCount() {
            return this.availableCount;
        }

        public int getBusyCount() {
            return this.busyCount;
        }

        public String toString() {
            return "Connections count: {total=" + this.totalCount + ", available=" + this.availableCount + ", busy=" + this.busyCount + '}';
        }
    }

    class ConnectionData {
        final Connection connection;
        long lastUsed;

        ConnectionData(Connection connection) {
            this.connection = connection;
            this.lastUsed = System.currentTimeMillis();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConnectionData that = (ConnectionData)o;
            return this.connection.equals(that.connection);
        }

        public int hashCode() {
            return this.connection.hashCode();
        }
    }
}

