/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.scope;

import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.config.InjectionPoint;
import jodd.madvoc.config.Targets;
import jodd.madvoc.scope.InstancesInjector;
import jodd.madvoc.scope.MadvocScope;

public class ServletContextScope
implements MadvocScope {
    protected final InstancesInjector instancesInjector = new InstancesInjector(this);

    @Override
    public void inject(ActionRequest actionRequest, Targets targets) {
        HttpServletRequest servletRequest = actionRequest.getHttpServletRequest();
        this.inject(servletRequest.getServletContext(), targets);
    }

    @Override
    public void inject(ServletContext servletContext, Targets targets) {
        this.instancesInjector.inject(servletContext, targets);
        Enumeration attributeNames = servletContext.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attrName = (String)attributeNames.nextElement();
            targets.forEachTargetAndIn(this, (target, in) -> {
                String name = in.matchedName(attrName);
                if (name != null) {
                    Object attrValue = servletContext.getAttribute(attrName);
                    target.writeValue(name, attrValue, true);
                }
            });
        }
    }

    @Override
    public void inject(Targets targets) {
    }

    @Override
    public void outject(ActionRequest actionRequest, Targets targets) {
        ServletContext context = actionRequest.getHttpServletRequest().getServletContext();
        targets.forEachTargetAndOut(this, (target, out) -> {
            Object value = target.readValue((InjectionPoint)out);
            context.setAttribute(out.name(), value);
        });
    }
}

