/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.io.File;
import java.util.function.Consumer;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Service;
import javax.mail.Session;
import javax.mail.Store;
import jodd.mail.EmailFilter;
import jodd.mail.EmailUtil;
import jodd.mail.MailException;
import jodd.mail.MailSession;
import jodd.mail.ReceivedEmail;
import jodd.mail.ReceiverBuilder;

public class ReceiveMailSession
extends MailSession<Store> {
    protected static final String DEFAULT_FOLDER = "INBOX";
    Folder folder;
    String folderName;
    private final File attachmentStorage;

    public ReceiveMailSession(Session session, Store store, File attachmentStorage) {
        super(session, (Service)store);
        this.attachmentStorage = attachmentStorage;
    }

    @Override
    public Store getService() {
        return (Store)this.service;
    }

    public String[] getAllFolders() {
        Folder[] folders;
        try {
            folders = this.getService().getDefaultFolder().list("*");
        }
        catch (MessagingException msgexc) {
            throw new MailException("Failed to connect to folder", msgexc);
        }
        String[] folderNames = new String[folders.length];
        for (int i = 0; i < folders.length; ++i) {
            Folder folder = folders[i];
            folderNames[i] = folder.getFullName();
        }
        return folderNames;
    }

    public void useFolder(String folderName) {
        this.closeFolderIfOpened(this.folder);
        try {
            this.folderName = folderName;
            this.folder = this.getService().getFolder(folderName);
            try {
                this.folder.open(2);
            }
            catch (MailException ignore) {
                this.folder.open(1);
            }
        }
        catch (MessagingException msgexc) {
            throw new MailException("Failed to connect to folder: " + folderName, msgexc);
        }
    }

    public Folder getFolder(String folder) {
        try {
            return this.getService().getFolder(folder);
        }
        catch (MessagingException e) {
            throw new MailException("Folder not found: " + folder, e);
        }
    }

    public void useDefaultFolder() {
        this.closeFolderIfOpened(this.folder);
        this.useFolder(DEFAULT_FOLDER);
    }

    private void useAndOpenFolderIfNotSet() {
        if (this.folder == null) {
            if (this.folderName != null) {
                this.useFolder(this.folderName);
            } else {
                this.useDefaultFolder();
            }
        }
    }

    public int getMessageCount() {
        this.useAndOpenFolderIfNotSet();
        try {
            return this.folder.getMessageCount();
        }
        catch (MessagingException msgexc) {
            throw new MailException(msgexc);
        }
    }

    public int getNewMessageCount() {
        this.useAndOpenFolderIfNotSet();
        try {
            return this.folder.getNewMessageCount();
        }
        catch (MessagingException msgexc) {
            throw new MailException(msgexc);
        }
    }

    public int getUnreadMessageCount() {
        this.useAndOpenFolderIfNotSet();
        try {
            return this.folder.getUnreadMessageCount();
        }
        catch (MessagingException msgexc) {
            throw new MailException(msgexc);
        }
    }

    public int getDeletedMessageCount() {
        this.useAndOpenFolderIfNotSet();
        try {
            return this.folder.getDeletedMessageCount();
        }
        catch (MessagingException msgexc) {
            throw new MailException(msgexc);
        }
    }

    public ReceiverBuilder receive() {
        return new ReceiverBuilder(this);
    }

    public ReceivedEmail[] receiveEmail() {
        return this.receiveMessages(null, null, null, false, null);
    }

    public ReceivedEmail[] receiveEmail(EmailFilter filter) {
        return this.receiveMessages(filter, null, null, false, null);
    }

    public ReceivedEmail[] receiveEmailAndMarkSeen() {
        return this.receiveEmailAndMarkSeen(null);
    }

    public ReceivedEmail[] receiveEmailAndMarkSeen(EmailFilter filter) {
        Flags flagsToSet = new Flags();
        flagsToSet.add(Flags.Flag.SEEN);
        return this.receiveMessages(filter, flagsToSet, null, false, null);
    }

    public ReceivedEmail[] receiveEmailAndDelete() {
        return this.receiveEmailAndDelete(null);
    }

    public ReceivedEmail[] receiveEmailAndDelete(EmailFilter filter) {
        Flags flags = new Flags();
        flags.add(Flags.Flag.SEEN);
        flags.add(Flags.Flag.DELETED);
        return this.receiveMessages(filter, flags, null, false, null);
    }

    public ReceivedEmail[] receiveEnvelopes() {
        return this.receiveEnvelopes(null);
    }

    public ReceivedEmail[] receiveEnvelopes(EmailFilter filter) {
        return this.receiveMessages(filter, null, null, true, null);
    }

    ReceivedEmail[] receiveMessages(EmailFilter filter, Flags flagsToSet, Flags flagsToUnset, boolean envelope, Consumer<Message[]> processedMessageConsumer) {
        this.useAndOpenFolderIfNotSet();
        try {
            Message[] messages = filter == null ? this.folder.getMessages() : this.folder.search(filter.getSearchTerm());
            if (messages.length == 0) {
                return ReceivedEmail.EMPTY_ARRAY;
            }
            if (envelope) {
                FetchProfile fetchProfile = new FetchProfile();
                fetchProfile.add(FetchProfile.Item.ENVELOPE);
                fetchProfile.add(FetchProfile.Item.FLAGS);
                this.folder.fetch(messages, fetchProfile);
            }
            ReceivedEmail[] emails = new ReceivedEmail[messages.length];
            for (int i = 0; i < messages.length; ++i) {
                Message msg = messages[i];
                emails[i] = new ReceivedEmail(msg, envelope, this.attachmentStorage);
                if (!EmailUtil.isEmptyFlags(flagsToSet)) {
                    emails[i].flags(flagsToSet);
                    msg.setFlags(flagsToSet, true);
                }
                if (!EmailUtil.isEmptyFlags(flagsToUnset)) {
                    emails[i].flags().remove(flagsToUnset);
                    msg.setFlags(flagsToUnset, false);
                }
                if (!EmailUtil.isEmptyFlags(flagsToSet) || emails[i].isSeen()) continue;
                msg.setFlag(Flags.Flag.SEEN, false);
            }
            if (processedMessageConsumer != null) {
                processedMessageConsumer.accept(messages);
            }
            if (!EmailUtil.isEmptyFlags(flagsToSet) && flagsToSet.contains(Flags.Flag.DELETED)) {
                this.folder.expunge();
            }
            return emails;
        }
        catch (MessagingException msgexc) {
            throw new MailException("Failed to fetch messages", msgexc);
        }
    }

    public void updateEmailFlags(ReceivedEmail receivedEmail) {
        this.useAndOpenFolderIfNotSet();
        try {
            this.folder.setFlags(new int[]{receivedEmail.messageNumber()}, receivedEmail.flags(), true);
        }
        catch (MessagingException mex) {
            throw new MailException("Failed to fetch messages", mex);
        }
    }

    protected void closeFolderIfOpened(Folder folder) {
        if (folder != null) {
            try {
                folder.close(true);
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
    }

    @Override
    public void close() {
        this.closeFolderIfOpened(this.folder);
        this.folder = null;
        this.folderName = null;
        super.close();
    }

    static {
        ReceiveMailSession.setupSystemMailProperties();
    }
}

