/*
 * Decompiled with CFR 0.152.
 */
package jodd.props;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Consumer;
import jodd.props.Props;
import jodd.props.PropsEntry;
import jodd.util.CollectionUtil;

public final class PropsEntries {
    private final PropsIterator propsIterator;
    private final Props props;

    public PropsEntries(Props props) {
        this.props = props;
        this.propsIterator = new PropsIterator();
    }

    public PropsEntries profile(String profile) {
        this.addProfiles(profile);
        return this;
    }

    public PropsEntries profile(String ... profiles) {
        if (profiles == null) {
            return this;
        }
        for (String profile : profiles) {
            this.addProfiles(profile);
        }
        return this;
    }

    public PropsEntries activeProfiles() {
        this.profile(this.props.activeProfiles);
        return this;
    }

    private void addProfiles(String profile) {
        if (this.propsIterator.profiles == null) {
            this.propsIterator.profiles = new ArrayList();
        }
        this.propsIterator.profiles.add(profile);
    }

    public PropsEntries section(String section) {
        this.addSection(section);
        return this;
    }

    public PropsEntries section(String ... section) {
        for (String s : section) {
            this.addSection(s);
        }
        return this;
    }

    private void addSection(String section) {
        if (this.propsIterator.sections == null) {
            this.propsIterator.sections = new ArrayList();
        }
        this.propsIterator.sections.add(section + '.');
    }

    public PropsEntries skipDuplicatesByValue() {
        this.propsIterator.skipDuplicatesByValue = true;
        this.propsIterator.skipDuplicatesByPosition = false;
        return this;
    }

    public PropsEntries skipDuplicatesByPosition() {
        this.propsIterator.skipDuplicatesByPosition = true;
        this.propsIterator.skipDuplicatesByValue = false;
        return this;
    }

    public Iterator<PropsEntry> iterator() {
        return this.propsIterator;
    }

    public void forEach(Consumer<PropsEntry> propsDataConsumer) {
        CollectionUtil.streamOf(this.propsIterator).forEach(propsDataConsumer);
    }

    private class PropsIterator
    implements Iterator<PropsEntry> {
        private PropsEntry next;
        private boolean firstTime;
        private List<String> profiles;
        private List<String> sections;
        private boolean skipDuplicatesByValue;
        private boolean skipDuplicatesByPosition;
        private Set<String> keys;

        private PropsIterator() {
            this.next = ((PropsEntries)PropsEntries.this).props.data.first;
            this.firstTime = true;
        }

        @Override
        public boolean hasNext() {
            if (this.firstTime) {
                this.start();
            }
            return this.next != null;
        }

        private void start() {
            this.firstTime = false;
            while (!this.accept(this.next) && this.next != null) {
                this.next = this.next.next;
            }
        }

        private boolean accept(PropsEntry entry) {
            boolean found;
            if (entry == null) {
                return false;
            }
            if (this.profiles != null) {
                if (entry.getProfile() != null) {
                    found = false;
                    for (String profile : this.profiles) {
                        if (!entry.getProfile().equals(profile)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        return false;
                    }
                }
            } else if (entry.getProfile() != null) {
                return false;
            }
            if (this.sections != null) {
                found = false;
                for (String section : this.sections) {
                    if (!entry.getKey().startsWith(section)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return false;
                }
            }
            if (this.profiles != null) {
                if (this.skipDuplicatesByValue) {
                    String thisProfile = entry.getProfile();
                    for (String profile : this.profiles) {
                        if (profile.equals(thisProfile)) {
                            return true;
                        }
                        Map<String, PropsEntry> profileMap = ((PropsEntries)PropsEntries.this).props.data.profileProperties.get(profile);
                        if (profileMap == null || !profileMap.containsKey(entry.getKey())) continue;
                        return false;
                    }
                }
                if (this.skipDuplicatesByPosition) {
                    if (this.keys == null) {
                        this.keys = new HashSet<String>();
                    }
                    if (!this.keys.add(entry.getKey())) {
                        return false;
                    }
                }
            }
            return true;
        }

        @Override
        public PropsEntry next() {
            if (this.firstTime) {
                this.start();
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            PropsEntry returnValue = this.next;
            while (this.next != null) {
                this.next = this.next.next;
                if (!this.accept(this.next)) continue;
                break;
            }
            return returnValue;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

