/*
 * Decompiled with CFR 0.152.
 */
package jodd.json;

import java.util.Objects;
import jodd.util.StringUtil;

public final class Path
implements Cloneable {
    private CharSequence[] paths;
    private int index;
    Path altPath;

    public static Path parse(String path) {
        return path == null ? new Path() : new Path((CharSequence[])StringUtil.splitc(path, '.'));
    }

    public Path() {
        this.paths = new CharSequence[8];
    }

    public Path(CharSequence ... fields) {
        if (fields.length >= 8) {
            this.paths = fields;
        } else {
            this.paths = new CharSequence[8];
            System.arraycopy(fields, 0, this.paths, 0, fields.length);
            this.index = fields.length;
        }
    }

    private Path(CharSequence[] paths, int index, Path altPath) {
        this.paths = paths;
        this.index = index;
        this.altPath = altPath;
    }

    public Path getAltPath() {
        return this.altPath;
    }

    public Path push(CharSequence field) {
        this._push(field);
        if (this.altPath != null) {
            this.altPath.push(field);
        }
        return this;
    }

    public Path push(CharSequence field, CharSequence altField) {
        this._push(field);
        if (this.altPath != null) {
            this.altPath.push(altField);
        }
        return this;
    }

    private void _push(CharSequence field) {
        if (this.index == this.paths.length) {
            CharSequence[] newPaths = new CharSequence[this.paths.length << 1];
            System.arraycopy(this.paths, 0, newPaths, 0, this.paths.length);
            this.paths = newPaths;
        }
        this.paths[this.index] = field;
        ++this.index;
    }

    public CharSequence pop() {
        if (this.altPath != null) {
            this.altPath.pop();
        }
        return this.paths[--this.index];
    }

    public int length() {
        return this.index;
    }

    public CharSequence get(int i) {
        if (i >= this.index) {
            throw new IndexOutOfBoundsException();
        }
        return this.paths[i];
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        for (int i = 0; i < this.index; ++i) {
            CharSequence current = this.paths[i];
            if (i > 0) {
                builder.append('.');
            }
            builder.append(current);
        }
        builder.append(']');
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        Path path1 = (Path)o;
        int length = path1.length();
        if (this.length() != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            CharSequence o1 = path1.paths[i];
            CharSequence o2 = this.paths[i];
            if (Objects.equals(o1, o2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.index; ++i) {
            CharSequence element = this.paths[i];
            result = 31 * result + (element == null ? 0 : element.hashCode());
        }
        return result;
    }

    public Path clone() {
        CharSequence[] clonedPaths = new CharSequence[this.paths.length];
        System.arraycopy(this.paths, 0, clonedPaths, 0, this.paths.length);
        return new Path(clonedPaths, this.index, this.altPath != null ? this.altPath.clone() : null);
    }
}

