/*
 * Decompiled with CFR 0.152.
 */
package jodd.json.impl;

import java.io.File;
import java.io.IOException;
import jodd.io.FileUtil;
import jodd.json.JsonContext;
import jodd.json.JsonException;
import jodd.json.TypeJsonSerializer;
import jodd.util.Base64;

public class FileJsonSerializer
implements TypeJsonSerializer<File> {
    private final Type serializationType;

    public FileJsonSerializer(Type serializationType) {
        this.serializationType = serializationType;
    }

    @Override
    public boolean serialize(JsonContext jsonContext, File file) {
        switch (this.serializationType) {
            case PATH: {
                jsonContext.writeString(file.getAbsolutePath());
                break;
            }
            case NAME: {
                jsonContext.writeString(file.getName());
                break;
            }
            case CONTENT: {
                byte[] bytes;
                try {
                    bytes = FileUtil.readBytes(file);
                }
                catch (IOException e) {
                    throw new JsonException("Unable to read files content", e);
                }
                String encoded = Base64.encodeToString(bytes);
                jsonContext.writeString(encoded);
                break;
            }
            default: {
                throw new JsonException("Invalid type");
            }
        }
        return true;
    }

    public static enum Type {
        PATH,
        NAME,
        CONTENT;

    }
}

