/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.config;

import java.util.function.Function;
import jodd.bean.BeanUtil;
import jodd.introspector.MapperFunction;
import jodd.madvoc.MadvocException;
import jodd.madvoc.config.InjectionPoint;
import jodd.madvoc.config.MethodParam;
import jodd.madvoc.config.ScopeData;
import jodd.typeconverter.TypeConverterManager;
import jodd.util.ClassUtil;

public class Target {
    private static final Function<Class, Object> VALUE_INSTANCE_CREATOR = type -> {
        try {
            return ClassUtil.newInstance(type);
        }
        catch (Exception ex) {
            throw new MadvocException(ex);
        }
    };
    private final Class type;
    private final ScopeData scopeData;
    private Object value;
    private final Function<Class, Object> valueInstanceCreator;
    private final MapperFunction mapperFunction;

    public static Target ofValue(Object value, ScopeData scopeData) {
        return new Target(value, null, scopeData, null, VALUE_INSTANCE_CREATOR);
    }

    public static Target ofMethodParam(MethodParam methodParam, Object object) {
        return new Target(object, methodParam.type(), methodParam.scopeData(), methodParam.mapperFunction(), VALUE_INSTANCE_CREATOR);
    }

    public static Target ofMethodParam(MethodParam methodParam, Function<Class, Object> valueInstanceCreator) {
        return new Target(null, methodParam.type(), methodParam.scopeData(), methodParam.mapperFunction(), valueInstanceCreator);
    }

    private Target(Object value, Class type, ScopeData scopeData, MapperFunction mapperFunction, Function<Class, Object> valueInstanceCreator) {
        this.value = value;
        this.type = type;
        this.scopeData = scopeData;
        this.valueInstanceCreator = valueInstanceCreator;
        this.mapperFunction = mapperFunction;
    }

    public Class type() {
        return this.type;
    }

    public Class resolveType() {
        if (this.type != null) {
            return this.type;
        }
        return this.value.getClass();
    }

    public Object value() {
        return this.value;
    }

    public ScopeData scopeData() {
        return this.scopeData;
    }

    public Object readValue(InjectionPoint injectionPoint) {
        return this.readValue(injectionPoint.targetName());
    }

    public Object readValue(String name) {
        String propertyName = name;
        if (this.type != null) {
            int dotNdx = propertyName.indexOf(46);
            if (dotNdx == -1) {
                return this.value;
            }
            propertyName = propertyName.substring(dotNdx + 1);
        }
        return BeanUtil.declared.getProperty(this.value, propertyName);
    }

    public void writeValue(InjectionPoint injectionPoint, Object propertyValue, boolean silent) {
        this.writeValue(injectionPoint.targetName(), propertyValue, silent);
    }

    public void writeValue(String name, Object propertyValue, boolean silent) {
        String propertyName = name;
        if (this.type != null) {
            int dotNdx = propertyName.indexOf(46);
            if (dotNdx == -1) {
                this.value = this.mapperFunction != null ? this.mapperFunction.apply(propertyValue) : TypeConverterManager.get().convertType(propertyValue, this.type);
                return;
            }
            if (this.value == null) {
                this.value = this.valueInstanceCreator.apply(this.type);
            }
            propertyName = propertyName.substring(dotNdx + 1);
        }
        if (silent) {
            BeanUtil.declaredForcedSilent.setProperty(this.value, propertyName, propertyValue);
        } else {
            BeanUtil.declaredForced.setProperty(this.value, propertyName, propertyValue);
        }
    }
}

