/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.interceptor;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.component.FileUploader;
import jodd.madvoc.component.MadvocEncoding;
import jodd.madvoc.component.ScopeResolver;
import jodd.madvoc.config.InjectionPoint;
import jodd.madvoc.config.Targets;
import jodd.madvoc.interceptor.ActionInterceptor;
import jodd.madvoc.meta.In;
import jodd.madvoc.meta.scope.MadvocContext;
import jodd.servlet.ServletUtil;
import jodd.servlet.upload.MultipartRequestWrapper;

public class ServletConfigInterceptor
implements ActionInterceptor {
    @In
    @MadvocContext
    protected ScopeResolver scopeResolver;
    @In
    @MadvocContext
    protected MadvocEncoding madvocEncoding;
    @In
    @MadvocContext
    protected FileUploader fileUploader;

    @Override
    public Object intercept(ActionRequest actionRequest) throws Exception {
        Object servletRequest = actionRequest.getHttpServletRequest();
        if (ServletUtil.isMultipartRequest(servletRequest)) {
            servletRequest = new MultipartRequestWrapper((HttpServletRequest)servletRequest, this.fileUploader.get(), this.madvocEncoding.getEncoding());
            actionRequest.bind((HttpServletRequest)servletRequest);
        }
        this.inject(actionRequest);
        Object result = actionRequest.invoke();
        this.outject(actionRequest);
        return result;
    }

    protected void inject(ActionRequest actionRequest) {
        Targets targets = actionRequest.getTargets();
        ServletContext servletContext = actionRequest.getHttpServletRequest().getServletContext();
        this.scopeResolver.forEachScope(madvocScope -> madvocScope.inject(servletContext, targets));
        this.scopeResolver.forEachScope(madvocScope -> madvocScope.inject(actionRequest, targets));
        targets.forEachTargetAndIn((target, injectionPoint) -> {
            Object value;
            String defaultValue = injectionPoint.defaultValue();
            if (!defaultValue.isEmpty() && (value = target.readValue((InjectionPoint)injectionPoint)) == null) {
                target.writeValue((InjectionPoint)injectionPoint, (Object)defaultValue, true);
            }
        });
    }

    protected void outject(ActionRequest actionRequest) {
        Targets targets = actionRequest.getTargets();
        this.scopeResolver.forEachScope(madvocScope -> madvocScope.outject(actionRequest, targets));
    }
}

