/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.scope;

import javax.servlet.ServletContext;
import jodd.json.JsonParser;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.config.InjectionPoint;
import jodd.madvoc.config.Targets;
import jodd.madvoc.scope.MadvocScope;
import jodd.util.StringUtil;

public class JsonBodyScope
implements MadvocScope {
    @Override
    public void inject(ActionRequest actionRequest, Targets targets) {
        String body = actionRequest.readRequestBody();
        if (StringUtil.isEmpty(body)) {
            return;
        }
        targets.forEachTargetAndIn(this, (target, in) -> {
            if (in.type() == String.class) {
                target.writeValue((InjectionPoint)in, (Object)body, true);
            } else {
                Object value = this.parseRequestBody(body, in.type());
                target.writeValue((InjectionPoint)in, value, true);
            }
        });
    }

    @Override
    public void inject(ServletContext servletContext, Targets targets) {
    }

    @Override
    public void inject(Targets targets) {
    }

    @Override
    public void outject(ActionRequest actionRequest, Targets targets) {
    }

    protected Object parseRequestBody(String body, Class targetType) {
        return JsonParser.create().parse(body, targetType);
    }
}

