/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;

public class RemoveSessionFromUrlFilter
implements Filter {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpSession session;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.isRequestedSessionIdFromURL(httpRequest) && (session = httpRequest.getSession(false)) != null) {
            session.invalidate();
        }
        HttpServletResponseWrapper wrappedResponse = new HttpServletResponseWrapper(httpResponse){

            public String encodeRedirectUrl(String url) {
                return url;
            }

            public String encodeRedirectURL(String url) {
                return url;
            }

            public String encodeUrl(String url) {
                return url;
            }

            public String encodeURL(String url) {
                return url;
            }
        };
        chain.doFilter(request, (ServletResponse)wrappedResponse);
    }

    protected boolean isRequestedSessionIdFromURL(HttpServletRequest servletRequest) {
        if (servletRequest.isRequestedSessionIdFromURL()) {
            return true;
        }
        HttpSession session = servletRequest.getSession(false);
        if (session != null) {
            String sessionId = session.getId();
            StringBuffer requestUri = servletRequest.getRequestURL();
            return requestUri.indexOf(sessionId) != -1;
        }
        return false;
    }

    public void init(FilterConfig config) {
    }

    public void destroy() {
    }
}

