/*
 * Decompiled with CFR 0.152.
 */
package jodd.bean;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import jodd.Jodd;
import jodd.bean.BeanException;
import jodd.bean.loader.BeanLoader;
import jodd.bean.loader.MapBeanLoader;
import jodd.bean.loader.ResultSetBeanLoader;
import jodd.util.ClassLoaderUtil;
import jodd.util.ReflectUtil;

public class BeanLoaderManager {
    protected static final Map<Class, BeanLoader> loaders = new HashMap<Class, BeanLoader>();

    public static void unregisterAll() {
        loaders.clear();
    }

    public static void registerDefaults() {
        BeanLoaderManager.register(Map.class, new MapBeanLoader());
        BeanLoaderManager.register(ResultSet.class, new ResultSetBeanLoader());
        if (Jodd.isServletLoaded()) {
            try {
                Class loaderAddon = ClassLoaderUtil.loadClass((String)"jodd.bean.loader.ServletBeanLoaderManagerAddon");
                ReflectUtil.invoke((Class)loaderAddon, (String)"registerDefaults", null);
            }
            catch (Exception ex) {
                throw new BeanException(ex);
            }
        }
    }

    public static void register(Class type, BeanLoader load) {
        loaders.put(type, load);
    }

    public static void unregister(Class type) {
        loaders.remove(type);
    }

    public static BeanLoader lookup(Class type) {
        return loaders.get(type);
    }

    public static BeanLoader lookup(Object source) {
        BeanLoader load = BeanLoaderManager.lookup(source.getClass());
        if (load == null) {
            for (Class key : loaders.keySet()) {
                if (!key.isInstance(source)) continue;
                load = BeanLoaderManager.lookup(key);
                break;
            }
        }
        return load;
    }

    static {
        BeanLoaderManager.registerDefaults();
    }
}

