/*
 * Decompiled with CFR 0.152.
 */
package jodd.bean;

import java.util.Map;
import java.util.Set;
import jodd.bean.BeanException;
import jodd.bean.BeanLoaderManager;
import jodd.bean.BeanUtil;
import jodd.bean.loader.BeanLoader;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;

public class BeanTool {
    public static void copy(Object source, Object destination, boolean suppressSecurity) {
        BeanTool.doCopy(source, destination, true, suppressSecurity);
    }

    public static void apply(Object source, Object destination, boolean suppressSecurity) {
        BeanTool.doCopy(source, destination, false, suppressSecurity);
    }

    public static void copy(Object source, Object destination) {
        BeanTool.doCopy(source, destination, true, false);
    }

    public static void apply(Object source, Object destination) {
        BeanTool.doCopy(source, destination, false, false);
    }

    private static void doCopy(Object source, Object destination, boolean copyNulls, boolean suppressSecurity) {
        String[] properties;
        for (String name : properties = BeanTool.resolveProperties(source, suppressSecurity)) {
            Object value = BeanUtil.getProperty(source, name);
            if (!copyNulls && value == null) continue;
            BeanUtil.setPropertySilent(destination, name, value);
        }
    }

    public static String[] resolveProperties(Object bean, boolean suppressSecurity) {
        String[] properties;
        if (bean instanceof Map) {
            Set key = ((Map)bean).keySet();
            String[] mdata = new String[key.size()];
            int ndx = 0;
            for (Object o : key) {
                mdata[ndx] = o.toString();
                ++ndx;
            }
            properties = mdata;
        } else {
            ClassDescriptor cdSrc = ClassIntrospector.lookup(bean.getClass());
            properties = cdSrc.getAllBeanGetterNames(suppressSecurity);
        }
        return properties;
    }

    public static void load(Object bean, Object source) {
        BeanLoader loader = BeanLoaderManager.lookup(source);
        if (loader == null) {
            throw new BeanException("No BeanLoader for: " + source.getClass().getName());
        }
        loader.load(bean, source);
    }

    public static void load(Object bean, Object source, Class type) {
        BeanLoader loader = BeanLoaderManager.lookup(type);
        if (loader == null) {
            throw new BeanException("No BeanLoader for: " + type.getName());
        }
        loader.load(bean, source);
    }
}

