/*
 * Decompiled with CFR 0.152.
 */
package jodd.bean;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jodd.bean.BeanException;
import jodd.bean.BeanProperty;
import jodd.bean.BeanUtilUtil;
import jodd.util.ReflectUtil;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanUtilBean
extends BeanUtilUtil {
    public static final String THIS_REF = "*this";
    private static final char[] INDEX_CHARS = new char[]{'.', '['};

    protected void resolveNestedProperties(BeanProperty bp) {
        int dotNdx;
        String name = bp.name;
        while ((dotNdx = this.indexOfDot(name)) != -1) {
            bp.last = false;
            bp.name = name.substring(0, dotNdx);
            bp.setBean(this.getIndexProperty(bp, true));
            name = name.substring(dotNdx + 1);
        }
        bp.last = true;
        bp.name = name;
    }

    protected boolean resolveExistingNestedProperties(BeanProperty bp) {
        int dotNdx;
        String name = bp.name;
        while ((dotNdx = this.indexOfDot(name)) != -1) {
            bp.last = false;
            String temp = bp.name = name.substring(0, dotNdx);
            if (!this.hasIndexProperty(bp, true)) {
                return false;
            }
            bp.name = temp;
            bp.setBean(this.getIndexProperty(bp, true));
            name = name.substring(dotNdx + 1);
        }
        bp.last = true;
        bp.name = name;
        return true;
    }

    public boolean hasSimpleProperty(Object bean, String property, boolean suppressSecurity) {
        return this.hasSimpleProperty(new BeanProperty(bean, property, false), suppressSecurity);
    }

    protected boolean hasSimpleProperty(BeanProperty bp, boolean suppressSecurity) {
        Map map;
        if (bp.bean == null) {
            return false;
        }
        bp.field = null;
        bp.method = bp.cd.getBeanGetter(bp.name, suppressSecurity);
        if (bp.method != null) {
            return true;
        }
        bp.field = bp.cd.getField(bp.name, suppressSecurity);
        if (bp.field != null) {
            return true;
        }
        return bp.cd.isMap() && (map = (Map)bp.bean).containsKey(bp.name);
    }

    public Object getSimpleProperty(Object bean, String property, boolean suppressSecurity) {
        return this.getSimpleProperty(new BeanProperty(bean, property, false), suppressSecurity);
    }

    public Object getSimplePropertyForced(Object bean, String property, boolean suppressSecurity) {
        return this.getSimpleProperty(new BeanProperty(bean, property, true), suppressSecurity);
    }

    protected Object getSimpleProperty(BeanProperty bp, boolean suppressSecurity) {
        if (bp.name.length() == 0 && bp.first || bp.name.equals(THIS_REF)) {
            return bp.bean;
        }
        bp.field = null;
        bp.method = bp.cd.getBeanGetter(bp.name, suppressSecurity);
        if (bp.method != null) {
            Object result = this.invokeGetter(bp.bean, bp.method);
            if (result == null && bp.forced) {
                result = this.createBeanProperty(bp);
            }
            return result;
        }
        bp.field = bp.cd.getField(bp.name, suppressSecurity);
        if (bp.field != null) {
            Object result = this.getField(bp.bean, bp.field);
            if (result == null && bp.forced) {
                result = this.createBeanProperty(bp);
            }
            return result;
        }
        if (bp.cd.isMap()) {
            Map map = (Map)bp.bean;
            if (!map.containsKey(bp.name)) {
                if (!bp.forced) {
                    throw new BeanException("Map key not found: " + bp.name, bp);
                }
                HashMap value = new HashMap();
                map.put(bp.name, value);
                return value;
            }
            return map.get(bp.name);
        }
        throw new BeanException("Simple property not found: " + bp.name, bp);
    }

    public void setSimpleProperty(Object bean, String property, Object value, boolean suppressSecurity) {
        this.setSimpleProperty(new BeanProperty(bean, property, false), value, suppressSecurity);
    }

    protected void setSimpleProperty(BeanProperty bp, Object value, boolean suppressSecurity) {
        Method method = bp.cd.getBeanSetter(bp.name, suppressSecurity);
        if (method != null) {
            this.invokeSetter(bp.bean, method, value);
            return;
        }
        Field field = bp.cd.getField(bp.name, suppressSecurity);
        if (field != null) {
            this.setField(bp.bean, field, value);
            return;
        }
        if (bp.cd.isMap()) {
            ((Map)bp.bean).put(bp.name, value);
            return;
        }
        throw new BeanException("Simple property not found: " + bp.name, bp);
    }

    public boolean hasIndexProperty(Object bean, String property, boolean suppressSecurity) {
        return this.hasIndexProperty(new BeanProperty(bean, property, false), suppressSecurity);
    }

    protected boolean hasIndexProperty(BeanProperty bp, boolean suppressSecurity) {
        if (bp.bean == null) {
            return false;
        }
        String indexString = this.extractIndex(bp);
        if (indexString == null) {
            return this.hasSimpleProperty(bp, suppressSecurity);
        }
        Object resultBean = this.getSimpleProperty(bp, suppressSecurity);
        if (resultBean == null) {
            return false;
        }
        if (resultBean.getClass().isArray()) {
            int index = this.parseInt(indexString, bp);
            return index >= 0 && index < Array.getLength(resultBean);
        }
        if (resultBean instanceof List) {
            int index = this.parseInt(indexString, bp);
            return index >= 0 && index < ((List)resultBean).size();
        }
        if (resultBean instanceof Map) {
            return ((Map)resultBean).containsKey(indexString);
        }
        return false;
    }

    public Object getIndexProperty(Object bean, String property, boolean suppressSecurity, boolean forced) {
        return this.getIndexProperty(new BeanProperty(bean, property, forced), suppressSecurity);
    }

    protected Object getIndexProperty(BeanProperty bp, boolean suppressSecurity) {
        String indexString = this.extractIndex(bp);
        Object resultBean = this.getSimpleProperty(bp, suppressSecurity);
        if (indexString == null) {
            return resultBean;
        }
        if (resultBean == null) {
            throw new BeanException("Index property is null: " + bp.name, bp);
        }
        if (resultBean.getClass().isArray()) {
            int index = this.parseInt(indexString, bp);
            if (bp.forced) {
                return this.arrayForcedGet(bp, resultBean, index);
            }
            return Array.get(resultBean, index);
        }
        if (resultBean instanceof List) {
            Object value;
            int index = this.parseInt(indexString, bp);
            List list = (List)resultBean;
            if (!bp.forced) {
                return list.get(index);
            }
            if (!bp.last) {
                this.ensureListSize(list, index);
            }
            if ((value = list.get(index)) == null) {
                Class<Map> listType = this.extracticGenericType(bp, 0);
                if (listType == null) {
                    listType = Map.class;
                }
                try {
                    value = ReflectUtil.newInstance(listType);
                }
                catch (Exception ex) {
                    throw new BeanException("Unable to create list element: " + bp.name + '[' + index + ']', bp, ex);
                }
                list.set(index, value);
            }
            return value;
        }
        if (resultBean instanceof Map) {
            Map map = (Map)resultBean;
            if (!bp.forced) {
                return map.get(indexString);
            }
            Object value = map.get(indexString);
            if (!bp.last && value == null) {
                Class<Map> mapType = this.extracticGenericType(bp, 1);
                if (mapType == null) {
                    mapType = Map.class;
                }
                try {
                    value = ReflectUtil.newInstance(mapType);
                }
                catch (Exception ex) {
                    throw new BeanException("Unable to create map element: " + bp.name + '[' + indexString + ']', bp, ex);
                }
                map.put(indexString, value);
            }
            return value;
        }
        throw new BeanException("Index property '" + bp.name + "' is not array, list or map.", bp);
    }

    public void setIndexProperty(Object bean, String property, Object value, boolean suppressSecurity, boolean forced) {
        this.setIndexProperty(new BeanProperty(bean, property, forced), value, suppressSecurity);
    }

    protected void setIndexProperty(BeanProperty bp, Object value, boolean suppressSecurity) {
        String indexString = this.extractIndex(bp);
        if (indexString == null) {
            this.setSimpleProperty(bp, value, suppressSecurity);
            return;
        }
        Object nextBean = this.getSimpleProperty(bp, suppressSecurity);
        if (nextBean.getClass().isArray()) {
            int index = this.parseInt(indexString, bp);
            if (bp.forced) {
                this.arrayForcedSet(bp, nextBean, index, value);
            } else {
                Array.set(nextBean, index, value);
            }
            return;
        }
        if (nextBean instanceof List) {
            int index = this.parseInt(indexString, bp);
            Class listType = this.extracticGenericType(bp, 0);
            if (listType != null) {
                value = this.convertType(value, listType);
            }
            List list = (List)nextBean;
            if (bp.forced) {
                this.ensureListSize(list, index);
            }
            list.set(index, value);
            return;
        }
        if (nextBean instanceof Map) {
            Map map = (Map)nextBean;
            Class mapType = this.extracticGenericType(bp, 1);
            if (mapType != null) {
                value = this.convertType(value, mapType);
            }
            map.put(indexString, value);
            return;
        }
        throw new BeanException("Index property '" + bp.name + "' is not array, list or map.", bp);
    }

    public void setProperty(Object bean, String name, Object value) {
        BeanProperty beanProperty = new BeanProperty(bean, name, false);
        this.resolveNestedProperties(beanProperty);
        this.setIndexProperty(beanProperty, value, false);
    }

    public boolean setPropertySilent(Object bean, String name, Object value) {
        BeanProperty beanProperty = new BeanProperty(bean, name, false);
        try {
            this.resolveNestedProperties(beanProperty);
            this.setIndexProperty(beanProperty, value, false);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public void setPropertyForced(Object bean, String name, Object value) {
        BeanProperty beanProperty = new BeanProperty(bean, name, true);
        this.resolveNestedProperties(beanProperty);
        this.setIndexProperty(beanProperty, value, false);
    }

    public boolean setPropertyForcedSilent(Object bean, String name, Object value) {
        BeanProperty beanProperty = new BeanProperty(bean, name, true);
        try {
            this.resolveNestedProperties(beanProperty);
            this.setIndexProperty(beanProperty, value, false);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public void setDeclaredProperty(Object bean, String name, Object value) {
        BeanProperty beanProperty = new BeanProperty(bean, name, false);
        this.resolveNestedProperties(beanProperty);
        this.setIndexProperty(beanProperty, value, true);
    }

    public boolean setDeclaredPropertySilent(Object bean, String name, Object value) {
        BeanProperty beanProperty = new BeanProperty(bean, name, false);
        try {
            this.resolveNestedProperties(beanProperty);
            this.setIndexProperty(beanProperty, value, true);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public void setDeclaredPropertyForced(Object bean, String name, Object value) {
        BeanProperty beanProperty = new BeanProperty(bean, name, true);
        this.resolveNestedProperties(beanProperty);
        this.setIndexProperty(beanProperty, value, true);
    }

    public boolean setDeclaredPropertyForcedSilent(Object bean, String name, Object value) {
        BeanProperty beanProperty = new BeanProperty(bean, name, true);
        try {
            this.resolveNestedProperties(beanProperty);
            this.setIndexProperty(beanProperty, value, true);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public Object getProperty(Object bean, String name) {
        BeanProperty beanProperty = new BeanProperty(bean, name, false);
        this.resolveNestedProperties(beanProperty);
        return this.getIndexProperty(beanProperty, false);
    }

    public Object getPropertySilently(Object bean, String name) {
        BeanProperty beanProperty = new BeanProperty(bean, name, false);
        try {
            this.resolveNestedProperties(beanProperty);
            return this.getIndexProperty(beanProperty, false);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public Object getDeclaredProperty(Object bean, String name) {
        BeanProperty beanProperty = new BeanProperty(bean, name, false);
        this.resolveNestedProperties(beanProperty);
        return this.getIndexProperty(beanProperty, true);
    }

    public Object getDeclaredPropertySilently(Object bean, String name) {
        BeanProperty beanProperty = new BeanProperty(bean, name, false);
        try {
            this.resolveNestedProperties(beanProperty);
            return this.getIndexProperty(beanProperty, true);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public boolean hasProperty(Object bean, String name) {
        BeanProperty beanProperty = new BeanProperty(bean, name, false);
        if (!this.resolveExistingNestedProperties(beanProperty)) {
            return false;
        }
        return this.hasIndexProperty(beanProperty, false);
    }

    public boolean hasDeclaredProperty(Object bean, String name) {
        BeanProperty beanProperty = new BeanProperty(bean, name, false);
        if (!this.resolveExistingNestedProperties(beanProperty)) {
            return false;
        }
        return this.hasIndexProperty(beanProperty, true);
    }

    public Class getPropertyType(Object bean, String name) {
        BeanProperty beanProperty = new BeanProperty(bean, name, false);
        if (!this.resolveExistingNestedProperties(beanProperty)) {
            return null;
        }
        this.hasIndexProperty(beanProperty, false);
        return this.extractType(beanProperty);
    }

    public Class getDeclaredPropertyType(Object bean, String name) {
        BeanProperty beanProperty = new BeanProperty(bean, name, false);
        if (!this.resolveExistingNestedProperties(beanProperty)) {
            return null;
        }
        this.hasIndexProperty(beanProperty, true);
        return this.extractType(beanProperty);
    }

    public void populateBean(Object bean, Map<?, ?> map) {
        this.populateProperty(bean, null, map);
    }

    public void populateProperty(Object bean, String name, Map<?, ?> map) {
        if (name != null) {
            if (map == null) {
                this.setSimpleProperty(bean, name, null, false);
                return;
            }
            bean = this.getSimplePropertyForced(bean, name, true);
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            if (value != null) {
                if (value instanceof Map) {
                    this.populateProperty(bean, key, (Map)value);
                    continue;
                }
                if (value instanceof List) {
                    this.populateProperty(bean, key, (List)value);
                    continue;
                }
            }
            this.setSimpleProperty(bean, key, value, true);
        }
    }

    public void populateProperty(Object bean, String name, List<?> list) {
        if (list == null) {
            this.setSimpleProperty(bean, name, null, false);
            return;
        }
        name = name + '[';
        int index = 0;
        for (Object item : list) {
            this.setIndexProperty(bean, name + index + ']', item, true, true);
            ++index;
        }
    }

    public String extractThisReference(String propertyName) {
        int ndx = StringUtil.indexOfChars((String)propertyName, (char[])INDEX_CHARS);
        if (ndx == -1) {
            return propertyName;
        }
        return propertyName.substring(0, ndx);
    }
}

