/*
 * Decompiled with CFR 0.152.
 */
package jodd.bean;

import java.util.Map;
import java.util.Set;
import jodd.bean.BeanUtil;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.MethodDescriptor;
import jodd.introspector.PropertyDescriptor;
import jodd.util.ArraysUtil;

public abstract class BeanVisitor {
    protected Object source;
    protected String[] excludeNames;
    protected String[] includeNames;
    protected boolean declared;
    protected boolean ignoreNullValues;

    protected String[] getAllBeanGetterNames(Class type, boolean declared) {
        ClassDescriptor classDescriptor = ClassIntrospector.lookup(type);
        PropertyDescriptor[] propertyDescriptors = classDescriptor.getAllPropertyDescriptors();
        String[] names = new String[propertyDescriptors.length];
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
            MethodDescriptor getter = propertyDescriptor.getReadMethodDescriptor();
            if (getter == null || !getter.matchDeclared(declared)) continue;
            names[i] = propertyDescriptor.getName();
        }
        return names;
    }

    protected String[] resolveProperties(Object bean, boolean declared) {
        String[] properties;
        if (bean instanceof Map) {
            Set keys = ((Map)bean).keySet();
            properties = new String[keys.size()];
            int ndx = 0;
            for (Object key : keys) {
                properties[ndx] = key.toString();
                ++ndx;
            }
        } else {
            properties = this.getAllBeanGetterNames(bean.getClass(), declared);
        }
        return properties;
    }

    public void visit() {
        String[] properties;
        for (String name : properties = this.resolveProperties(this.source, false)) {
            Object value;
            if (name == null || this.excludeNames != null && ArraysUtil.contains((Object[])this.excludeNames, (Object)name) || this.includeNames != null && !ArraysUtil.contains((Object[])this.includeNames, (Object)name) || (value = this.declared ? BeanUtil.getDeclaredProperty(this.source, name) : BeanUtil.getProperty(this.source, name)) == null && this.ignoreNullValues) continue;
            this.visitProperty(name, value);
        }
    }

    protected abstract boolean visitProperty(String var1, Object var2);
}

