/*
 * Decompiled with CFR 0.152.
 */
package jodd.bean;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import jodd.JoddBean;
import jodd.bean.BeanException;
import jodd.bean.BeanProperty;
import jodd.typeconverter.TypeConverterManager;
import jodd.typeconverter.TypeConverterManagerBean;
import jodd.util.ReflectUtil;

class BeanUtilUtil {
    protected TypeConverterManagerBean typeConverterManager = TypeConverterManager.getDefaultTypeConverterManager();

    BeanUtilUtil() {
    }

    public void setTypeConverterManager(TypeConverterManagerBean typeConverterManager) {
        this.typeConverterManager = typeConverterManager;
    }

    protected Object convertType(Object value, Class type) {
        value = this.typeConverterManager.convertType(value, type);
        return value;
    }

    protected void invokeSetter(Object bean, Method m, Object value) {
        try {
            Class<?>[] paramTypes = m.getParameterTypes();
            value = this.convertType(value, paramTypes[0]);
            m.invoke(bean, value);
        }
        catch (Exception ex) {
            throw new BeanException("Unable to invoke setter: " + bean.getClass().getSimpleName() + '#' + m.getName() + "()", ex);
        }
    }

    protected Object invokeGetter(Object bean, Method m) {
        try {
            return m.invoke(bean, new Object[0]);
        }
        catch (Exception ex) {
            throw new BeanException("Unable to invoke getter: " + bean.getClass().getSimpleName() + '#' + m.getName() + "()", ex);
        }
    }

    protected void setFieldValue(Object bean, Field f, Object value) {
        try {
            Class<?> type = f.getType();
            value = this.convertType(value, type);
            f.set(bean, value);
        }
        catch (Exception ex) {
            throw new BeanException("Unable to set field: " + bean.getClass().getSimpleName() + '#' + f.getName(), ex);
        }
    }

    protected Object getFieldValue(Object bean, Field f) {
        try {
            return f.get(bean);
        }
        catch (Exception ex) {
            throw new BeanException("Unable to get field " + bean.getClass().getSimpleName() + '#' + f.getName(), ex);
        }
    }

    protected Object arrayForcedGet(BeanProperty bp, Object array, int index) {
        Object value;
        Class<?> componentType = array.getClass().getComponentType();
        if (!bp.last) {
            array = this.ensureArraySize(bp, array, componentType, index);
        }
        if ((value = Array.get(array, index)) == null) {
            try {
                value = ReflectUtil.newInstance(componentType);
            }
            catch (Exception ex) {
                throw new BeanException("Unable to create array element: " + bp.name + '[' + index + ']', bp, ex);
            }
            Array.set(array, index, value);
        }
        return value;
    }

    protected void arrayForcedSet(BeanProperty bp, Object array, int index, Object value) {
        Class<?> componentType = array.getClass().getComponentType();
        array = this.ensureArraySize(bp, array, componentType, index);
        value = this.convertType(value, componentType);
        Array.set(array, index, value);
    }

    protected Object ensureArraySize(BeanProperty bp, Object array, Class componentType, int index) {
        int len = Array.getLength(array);
        if (index >= len) {
            Object newArray = Array.newInstance(componentType, index + 1);
            System.arraycopy(array, 0, newArray, 0, len);
            Method setter = bp.cd.getBeanSetter(bp.name, true);
            if (setter != null) {
                this.invokeSetter(bp.bean, setter, newArray);
            } else {
                Field field = this.getField(bp, true);
                if (field == null) {
                    throw new BeanException("Unable to find setter or field named as: " + bp.name, bp);
                }
                this.setFieldValue(bp.bean, field, newArray);
            }
            array = newArray;
        }
        return array;
    }

    protected void ensureListSize(List list, int size) {
        for (int len = list.size(); size >= len; ++len) {
            list.add(null);
        }
    }

    protected int indexOfDot(String name) {
        int len = name.length();
        boolean insideBracket = false;
        for (int ndx = 0; ndx < len; ++ndx) {
            char c = name.charAt(ndx);
            if (insideBracket) {
                if (c != ']') continue;
                insideBracket = false;
                continue;
            }
            if (c == '.') {
                return ndx;
            }
            if (c != '[') continue;
            insideBracket = true;
        }
        return -1;
    }

    protected String extractIndex(BeanProperty bp) {
        int leftBracketNdx;
        bp.index = null;
        String name = bp.name;
        int lastNdx = name.length() - 1;
        if (lastNdx < 0) {
            return null;
        }
        if (name.charAt(lastNdx) == ']' && (leftBracketNdx = name.lastIndexOf(91)) != -1) {
            bp.name = name.substring(0, leftBracketNdx);
            bp.index = name.substring(leftBracketNdx + 1, lastNdx);
            return bp.index;
        }
        return null;
    }

    protected int parseInt(String indexString, BeanProperty bp) {
        try {
            return Integer.parseInt(indexString);
        }
        catch (NumberFormatException nfex) {
            throw new BeanException("Invalid index: " + indexString, bp, nfex);
        }
    }

    protected Object createBeanProperty(BeanProperty bp) {
        Object newInstance;
        Class<?> type;
        Method setter = bp.cd.getBeanSetter(bp.name, true);
        Field field = null;
        if (setter != null) {
            type = setter.getParameterTypes()[0];
        } else {
            field = this.getField(bp, true);
            if (field == null) {
                return null;
            }
            type = field.getType();
        }
        try {
            newInstance = ReflectUtil.newInstance(type);
        }
        catch (Exception ex) {
            throw new BeanException("Unable to create '" + bp.name + "' property.", bp, ex);
        }
        if (setter != null) {
            this.invokeSetter(bp.bean, setter, newInstance);
        } else {
            this.setFieldValue(bp.bean, field, newInstance);
        }
        return newInstance;
    }

    protected Class extracticGenericType(BeanProperty bp, int index) {
        Type type;
        if (bp.field != null) {
            type = bp.field.getGenericType();
        } else if (bp.method != null) {
            type = bp.method.getGenericReturnType();
        } else {
            return null;
        }
        return ReflectUtil.getComponentType((Type)type, (int)index);
    }

    protected Class extractType(BeanProperty bp) {
        Class<?> type = null;
        if (bp.field != null) {
            if (bp.index != null && (type = ReflectUtil.getComponentType((Type)bp.field.getGenericType())) == null) {
                return Object.class;
            }
            if (type == null) {
                type = bp.field.getType();
            }
        } else if (bp.method != null) {
            if (bp.index != null && (type = ReflectUtil.getComponentType((Type)bp.method.getGenericReturnType())) == null) {
                return Object.class;
            }
            if (type == null) {
                type = bp.method.getReturnType();
            }
        }
        return type;
    }

    protected Field getField(BeanProperty bp, boolean declared) {
        String fieldName = bp.name;
        if (JoddBean.fieldPrefix != null) {
            fieldName = JoddBean.fieldPrefix + fieldName;
        }
        return bp.cd.getField(fieldName, declared);
    }
}

