/*
 * Decompiled with CFR 0.152.
 */
package jodd.introspector;

import java.util.HashMap;
import java.util.Map;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.Introspector;

public class AccessibleIntrospector
implements Introspector {
    protected final Map<Class, ClassDescriptor> cache = new HashMap<Class, ClassDescriptor>();

    public ClassDescriptor lookup(Class type) {
        ClassDescriptor cd = this.cache.get(type);
        if (cd != null) {
            cd.increaseUsageCount();
            return cd;
        }
        cd = this.describeClass(type);
        this.cache.put(type, cd);
        return cd;
    }

    public ClassDescriptor register(Class type) {
        ClassDescriptor cd = this.describeClass(type);
        this.cache.put(type, cd);
        return cd;
    }

    protected ClassDescriptor describeClass(Class type) {
        return new ClassDescriptor(type, true);
    }

    public void reset() {
        this.cache.clear();
    }
}

