/*
 * Decompiled with CFR 0.152.
 */
package jodd.introspector;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jodd.introspector.Ctors;
import jodd.introspector.FieldDescriptor;
import jodd.introspector.Fields;
import jodd.introspector.MethodDescriptor;
import jodd.introspector.Methods;
import jodd.introspector.Properties;
import jodd.util.ReflectUtil;

public class ClassDescriptor {
    protected final Class type;
    protected final boolean accessibleOnly;
    protected int usageCount;
    private final boolean isArray;
    private final boolean isMap;
    private final boolean isList;
    private final boolean isSet;
    private final boolean isCollection;
    protected Fields publicFields;
    protected Fields allFields;
    protected Methods publicMethods;
    protected Methods allMethods;
    protected Properties publicProperties;
    protected Properties allProperties;
    protected Ctors publicCtors;
    protected Ctors allCtors;

    public ClassDescriptor(Class type, boolean accessibleOnly) {
        this.type = type;
        this.isArray = type.isArray();
        this.isMap = ReflectUtil.isSubclass((Class)type, Map.class);
        this.isList = ReflectUtil.isSubclass((Class)type, List.class);
        this.isSet = ReflectUtil.isSubclass((Class)type, Set.class);
        this.isCollection = ReflectUtil.isSubclass((Class)type, Collection.class);
        this.accessibleOnly = accessibleOnly;
    }

    public Class getType() {
        return this.type;
    }

    protected void increaseUsageCount() {
        ++this.usageCount;
    }

    public int getUsageCount() {
        return this.usageCount;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isMap() {
        return this.isMap;
    }

    public boolean isList() {
        return this.isList;
    }

    public boolean isSet() {
        return this.isSet;
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    protected void inspectFields() {
        if (this.allFields != null) {
            return;
        }
        Field[] fields = this.accessibleOnly ? ReflectUtil.getAccessibleFields((Class)this.type) : ReflectUtil.getSupportedFields((Class)this.type);
        Fields publicFields = new Fields(this, fields.length);
        Fields allFields = new Fields(this, fields.length);
        for (Field field : fields) {
            String fName = field.getName();
            if (ReflectUtil.isPublic((Member)field)) {
                publicFields.addField(fName, field);
            }
            ReflectUtil.forceAccess((AccessibleObject)field);
            allFields.addField(fName, field);
        }
        this.publicFields = publicFields;
        this.allFields = allFields;
    }

    public Field getField(String name, boolean declared) {
        this.inspectFields();
        Fields fields = declared ? this.allFields : this.publicFields;
        return fields.getField(name);
    }

    public int getFieldsCount(boolean declared) {
        this.inspectFields();
        Fields fields = declared ? this.allFields : this.publicFields;
        return fields.getCount();
    }

    public Field[] getAllFields(boolean declared) {
        this.inspectFields();
        Fields fields = declared ? this.allFields : this.publicFields;
        return fields.getAllFields();
    }

    public FieldDescriptor getFieldDescriptor(String name, boolean declared) {
        this.inspectFields();
        Fields fields = declared ? this.allFields : this.publicFields;
        return fields.getFieldDescriptor(name);
    }

    protected void inspectMethods() {
        if (this.allMethods != null) {
            return;
        }
        Method[] methods = this.accessibleOnly ? ReflectUtil.getAccessibleMethods((Class)this.type) : ReflectUtil.getSupportedMethods((Class)this.type);
        Methods publicMethods = new Methods(this, methods.length);
        Methods allMethods = new Methods(this, methods.length);
        for (Method method : methods) {
            String methodName = method.getName();
            if (ReflectUtil.isPublic((Member)method)) {
                publicMethods.addMethod(methodName, method);
            }
            ReflectUtil.forceAccess((AccessibleObject)method);
            allMethods.addMethod(methodName, method);
        }
        this.allMethods = allMethods;
        this.publicMethods = publicMethods;
    }

    public int getMethodsCount(boolean declared) {
        this.inspectMethods();
        Methods methods = declared ? this.allMethods : this.publicMethods;
        return methods.getCount();
    }

    public Method getMethod(String name, boolean declared) {
        this.inspectMethods();
        Methods methods = declared ? this.allMethods : this.publicMethods;
        return methods.getMethod(name);
    }

    public Method getMethod(String name, Class[] params, boolean declared) {
        this.inspectMethods();
        Methods methods = declared ? this.allMethods : this.publicMethods;
        return methods.getMethod(name, params);
    }

    public MethodDescriptor getMethodDescriptor(String name, Class[] params, boolean declared) {
        this.inspectMethods();
        Methods methods = declared ? this.allMethods : this.publicMethods;
        return methods.getMethodDescriptor(name, params);
    }

    public Method[] getAllMethods(String name, boolean declared) {
        this.inspectMethods();
        Methods methods = declared ? this.allMethods : this.publicMethods;
        return methods.getAllMethods(name);
    }

    public Method[] getAllMethods(boolean declared) {
        this.inspectMethods();
        Methods methods = declared ? this.allMethods : this.publicMethods;
        return methods.getAllMethods();
    }

    protected void inspectProperties() {
        Method[] methods;
        if (this.publicProperties != null) {
            return;
        }
        Properties publicProperties = new Properties(this);
        Properties allProperties = new Properties(this);
        for (Method method : methods = this.accessibleOnly ? ReflectUtil.getAccessibleMethods((Class)this.type) : ReflectUtil.getSupportedMethods((Class)this.type)) {
            if (Modifier.isStatic(method.getModifiers())) continue;
            boolean add = false;
            String methodName = ReflectUtil.getBeanPropertyGetterName((Method)method);
            if (methodName != null) {
                methodName = '-' + methodName;
                add = true;
            } else {
                methodName = ReflectUtil.getBeanPropertySetterName((Method)method);
                if (methodName != null) {
                    methodName = '+' + methodName;
                    add = true;
                }
            }
            if (!add) continue;
            if (ReflectUtil.isPublic((Member)method)) {
                publicProperties.addMethod(methodName, method);
            }
            ReflectUtil.forceAccess((AccessibleObject)method);
            allProperties.addMethod(methodName, method);
        }
        this.allProperties = allProperties;
        this.publicProperties = publicProperties;
    }

    public Method getBeanSetter(String name, boolean declared) {
        this.inspectProperties();
        Properties properties = declared ? this.allProperties : this.publicProperties;
        return properties.getSetters().getMethod(name);
    }

    public MethodDescriptor getBeanSetterMethodDescriptor(String name, boolean declared) {
        this.inspectProperties();
        Properties properties = declared ? this.allProperties : this.publicProperties;
        return properties.getSetters().getMethodDescriptor(name);
    }

    public Method[] getAllBeanSetters(boolean declared) {
        this.inspectProperties();
        Properties properties = declared ? this.allProperties : this.publicProperties;
        return properties.getSetters().getAllMethods();
    }

    public String[] getAllBeanSetterNames(boolean declared) {
        this.inspectProperties();
        Properties properties = declared ? this.allProperties : this.publicProperties;
        return properties.getSetterNames();
    }

    public Method getBeanGetter(String name, boolean declared) {
        this.inspectProperties();
        Properties properties = declared ? this.allProperties : this.publicProperties;
        return properties.getGetters().getMethod(name);
    }

    public MethodDescriptor getBeanGetterMethodDescriptor(String name, boolean declared) {
        this.inspectProperties();
        Properties properties = declared ? this.allProperties : this.publicProperties;
        return properties.getGetters().getMethodDescriptor(name);
    }

    public Method[] getAllBeanGetters(boolean declared) {
        this.inspectProperties();
        Properties properties = declared ? this.allProperties : this.publicProperties;
        return properties.getGetters().getAllMethods();
    }

    public String[] getAllBeanGetterNames(boolean declared) {
        this.inspectProperties();
        Properties properties = declared ? this.allProperties : this.publicProperties;
        return properties.getGetterNames();
    }

    protected void inspectCtors() {
        Constructor[] ctors;
        if (this.allCtors != null) {
            return;
        }
        Ctors publicCtors = new Ctors(this);
        Ctors allCtors = new Ctors(this);
        publicCtors.addCtors(this.type.getConstructors());
        allCtors.addCtors(this.type.getDeclaredConstructors());
        for (Constructor ctor : ctors = allCtors.getAllCtors()) {
            if (ReflectUtil.isPublic((Member)ctor)) continue;
            ReflectUtil.forceAccess((AccessibleObject)ctor);
        }
        this.publicCtors = publicCtors;
        this.allCtors = allCtors;
    }

    public Constructor getDefaultCtor(boolean declared) {
        this.inspectCtors();
        Ctors ctors = declared ? this.allCtors : this.publicCtors;
        return ctors.getDefaultCtor();
    }

    public Constructor getCtor(Class[] args, boolean declared) {
        this.inspectCtors();
        Ctors ctors = declared ? this.allCtors : this.publicCtors;
        return ctors.getCtor(args);
    }

    public Constructor getDefaultCtor() {
        this.inspectCtors();
        return this.publicCtors.getDefaultCtor();
    }

    public int getCtorsCount(boolean declared) {
        this.inspectCtors();
        Ctors ctors = declared ? this.allCtors : this.publicCtors;
        return ctors.getCount();
    }

    public Constructor[] getAllCtors(boolean declared) {
        this.inspectCtors();
        Ctors ctors = declared ? this.allCtors : this.publicCtors;
        return ctors.getAllCtors();
    }
}

