/*
 * Decompiled with CFR 0.152.
 */
package jodd.introspector;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.Descriptor;
import jodd.introspector.Getter;
import jodd.introspector.Setter;
import jodd.util.ReflectUtil;

public class MethodDescriptor
extends Descriptor
implements Getter,
Setter {
    protected final Method method;
    protected final Type returnType;
    protected final Class rawReturnType;
    protected final Class rawReturnComponentType;
    protected final Class rawReturnKeyComponentType;
    protected final Class[] rawParameterTypes;
    protected final Class[] rawParameterComponentTypes;

    public MethodDescriptor(ClassDescriptor classDescriptor, Method method) {
        super(classDescriptor, ReflectUtil.isPublic((Member)method));
        this.method = method;
        this.returnType = method.getGenericReturnType();
        this.rawReturnType = ReflectUtil.getRawType((Type)this.returnType, (Class)classDescriptor.getType());
        this.rawReturnComponentType = ReflectUtil.getComponentType((Type)this.returnType, (Class)classDescriptor.getType());
        this.rawReturnKeyComponentType = ReflectUtil.getComponentType((Type)this.returnType, (Class)classDescriptor.getType(), (int)0);
        ReflectUtil.forceAccess((AccessibleObject)method);
        Type[] params = method.getGenericParameterTypes();
        Type[] genericParams = method.getGenericParameterTypes();
        this.rawParameterTypes = new Class[params.length];
        this.rawParameterComponentTypes = genericParams.length == 0 ? null : new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            Type type = params[i];
            this.rawParameterTypes[i] = ReflectUtil.getRawType((Type)type, (Class)classDescriptor.getType());
            if (this.rawParameterComponentTypes == null) continue;
            this.rawParameterComponentTypes[i] = ReflectUtil.getComponentType((Type)genericParams[i], (Class)classDescriptor.getType());
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public Class getRawReturnType() {
        return this.rawReturnType;
    }

    public Class getRawReturnComponentType() {
        return this.rawReturnComponentType;
    }

    public Class getRawReturnKeyComponentType() {
        return this.rawReturnKeyComponentType;
    }

    public Class resolveRawReturnComponentType(int index) {
        return ReflectUtil.getComponentType((Type)this.returnType, (Class)this.classDescriptor.getType(), (int)index);
    }

    public Class[] getRawParameterTypes() {
        return this.rawParameterTypes;
    }

    public Class[] getRawParameterComponentTypes() {
        return this.rawParameterComponentTypes;
    }

    public Object invokeGetter(Object target) throws InvocationTargetException, IllegalAccessException {
        return this.method.invoke(target, null);
    }

    public Class getGetterRawType() {
        return this.getRawReturnType();
    }

    public Class getGetterRawComponentType() {
        return this.getRawReturnComponentType();
    }

    public Class getGetterRawKeyComponentType() {
        return this.getRawReturnKeyComponentType();
    }

    public void invokeSetter(Object target, Object argument) throws IllegalAccessException, InvocationTargetException {
        this.method.invoke(target, argument);
    }

    public Class getSetterRawType() {
        return this.getRawParameterTypes()[0];
    }

    public Class getSetterRawComponentType() {
        Class[] ts = this.getRawParameterComponentTypes();
        if (ts == null) {
            return null;
        }
        return ts[0];
    }

    public String toString() {
        return this.classDescriptor.getType().getSimpleName() + '#' + this.method.getName() + "()";
    }
}

