/*
 * Decompiled with CFR 0.152.
 */
package jodd.bean;

import java.lang.reflect.Array;
import java.util.List;
import jodd.JoddBean;
import jodd.bean.BeanException;
import jodd.bean.BeanProperty;
import jodd.introspector.Getter;
import jodd.introspector.Introspector;
import jodd.introspector.Setter;
import jodd.typeconverter.TypeConverterManager;
import jodd.typeconverter.TypeConverterManagerBean;
import jodd.util.ReflectUtil;

class BeanUtilUtil {
    protected Introspector introspector = JoddBean.introspector;
    protected TypeConverterManagerBean typeConverterManager = TypeConverterManager.getDefaultTypeConverterManager();

    BeanUtilUtil() {
    }

    public void setIntrospector(Introspector introspector) {
        this.introspector = introspector;
    }

    public Introspector getIntrospector() {
        return this.introspector;
    }

    public void setTypeConverterManager(TypeConverterManagerBean typeConverterManager) {
        this.typeConverterManager = typeConverterManager;
    }

    public TypeConverterManagerBean getTypeConverterManager() {
        return this.typeConverterManager;
    }

    protected Object convertType(Object value, Class type) {
        return this.typeConverterManager.convertType(value, type);
    }

    protected void invokeSetter(Setter setter, Object bean, Object value) {
        try {
            Class type = setter.getSetterRawType();
            value = this.convertType(value, type);
            setter.invokeSetter(bean, value);
        }
        catch (Exception ex) {
            throw new BeanException("Setter failed: " + setter, ex);
        }
    }

    protected Object arrayForcedGet(BeanProperty bp, Object array, int index) {
        Object value;
        Class<?> componentType = array.getClass().getComponentType();
        if (!bp.last) {
            array = this.ensureArraySize(bp, array, componentType, index);
        }
        if ((value = Array.get(array, index)) == null) {
            try {
                value = ReflectUtil.newInstance(componentType);
            }
            catch (Exception ex) {
                throw new BeanException("Invalid array element: " + bp.name + '[' + index + ']', bp, ex);
            }
            Array.set(array, index, value);
        }
        return value;
    }

    protected void arrayForcedSet(BeanProperty bp, Object array, int index, Object value) {
        Class<?> componentType = array.getClass().getComponentType();
        array = this.ensureArraySize(bp, array, componentType, index);
        value = this.convertType(value, componentType);
        Array.set(array, index, value);
    }

    protected Object ensureArraySize(BeanProperty bp, Object array, Class componentType, int index) {
        int len = Array.getLength(array);
        if (index >= len) {
            Object newArray = Array.newInstance(componentType, index + 1);
            System.arraycopy(array, 0, newArray, 0, len);
            Setter setter = bp.getSetter(true);
            if (setter == null) {
                throw new BeanException("Setter or field not found: " + bp.name, bp);
            }
            this.invokeSetter(setter, bp.bean, newArray);
            array = newArray;
        }
        return array;
    }

    protected void ensureListSize(List list, int size) {
        for (int len = list.size(); size >= len; ++len) {
            list.add(null);
        }
    }

    protected int indexOfDot(String name) {
        int len = name.length();
        boolean insideBracket = false;
        for (int ndx = 0; ndx < len; ++ndx) {
            char c = name.charAt(ndx);
            if (insideBracket) {
                if (c != ']') continue;
                insideBracket = false;
                continue;
            }
            if (c == '.') {
                return ndx;
            }
            if (c != '[') continue;
            insideBracket = true;
        }
        return -1;
    }

    protected String extractIndex(BeanProperty bp) {
        int leftBracketNdx;
        bp.index = null;
        String name = bp.name;
        int lastNdx = name.length() - 1;
        if (lastNdx < 0) {
            return null;
        }
        if (name.charAt(lastNdx) == ']' && (leftBracketNdx = name.lastIndexOf(91)) != -1) {
            bp.setName(name.substring(0, leftBracketNdx));
            bp.index = name.substring(leftBracketNdx + 1, lastNdx);
            return bp.index;
        }
        return null;
    }

    protected int parseInt(String indexString, BeanProperty bp) {
        try {
            return Integer.parseInt(indexString);
        }
        catch (NumberFormatException nfex) {
            throw new BeanException("Invalid index: " + indexString, bp, nfex);
        }
    }

    protected Object createBeanProperty(BeanProperty bp) {
        Object newInstance;
        Setter setter = bp.getSetter(true);
        if (setter == null) {
            return null;
        }
        Class type = setter.getSetterRawType();
        try {
            newInstance = ReflectUtil.newInstance((Class)type);
        }
        catch (Exception ex) {
            throw new BeanException("Invalid property: " + bp.name, bp, ex);
        }
        this.invokeSetter(setter, bp.bean, newInstance);
        return newInstance;
    }

    protected Class extractGenericComponentType(Getter getter) {
        Class<Object> componentType = null;
        if (getter != null) {
            componentType = getter.getGetterRawComponentType();
        }
        if (componentType == null) {
            componentType = Object.class;
        }
        return componentType;
    }

    protected Object convertIndexToMapKey(Getter getter, Object index) {
        Class<Object> indexType = null;
        if (getter != null) {
            indexType = getter.getGetterRawKeyComponentType();
        }
        if (indexType == null) {
            indexType = Object.class;
        }
        if (indexType == Object.class) {
            return index;
        }
        try {
            return this.convertType(index, indexType);
        }
        catch (Exception ignore) {
            return index;
        }
    }

    protected Class extractType(BeanProperty bp, boolean declared) {
        Getter getter = bp.getGetter(declared);
        if (getter != null) {
            if (bp.index != null) {
                Class type = getter.getGetterRawComponentType();
                return type == null ? Object.class : type;
            }
            return getter.getGetterRawType();
        }
        return null;
    }
}

