/*
 * Decompiled with CFR 0.152.
 */
package jodd.introspector;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.Descriptor;
import jodd.introspector.Getter;
import jodd.introspector.Setter;
import jodd.util.ReflectUtil;

public class MethodDescriptor
extends Descriptor
implements Getter,
Setter {
    protected final Method method;
    protected final Type returnType;
    protected final Class rawReturnType;
    protected final Class rawReturnComponentType;
    protected final Class rawReturnKeyComponentType;
    protected final Class[] rawParameterTypes;

    public MethodDescriptor(ClassDescriptor classDescriptor, Method method) {
        super(classDescriptor, ReflectUtil.isPublic((Member)method));
        this.method = method;
        this.returnType = method.getGenericReturnType();
        this.rawReturnType = ReflectUtil.getRawType((Type)this.returnType, (Class)classDescriptor.getType());
        this.rawReturnComponentType = ReflectUtil.getComponentType((Type)this.returnType, (Class)classDescriptor.getType());
        this.rawReturnKeyComponentType = ReflectUtil.getComponentType((Type)this.returnType, (Class)classDescriptor.getType(), (int)0);
        ReflectUtil.forceAccess((AccessibleObject)method);
        Type[] params = method.getGenericParameterTypes();
        this.rawParameterTypes = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            Type type = params[i];
            this.rawParameterTypes[i] = ReflectUtil.getRawType((Type)type, (Class)classDescriptor.getType());
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public Class getRawReturnType() {
        return this.rawReturnType;
    }

    public Class getRawReturnComponentType() {
        return this.rawReturnComponentType;
    }

    public Class getRawReturnKeyComponentType() {
        return this.rawReturnKeyComponentType;
    }

    public Class resolveRawReturnComponentType(int index) {
        return ReflectUtil.getComponentType((Type)this.returnType, (Class)this.classDescriptor.getType(), (int)index);
    }

    public Class[] getRawParameterTypes() {
        return this.rawParameterTypes;
    }

    public Object invokeGetter(Object target) throws InvocationTargetException, IllegalAccessException {
        return this.method.invoke(target, null);
    }

    public Class getGetterRawType() {
        return this.getRawReturnType();
    }

    public Class getGetterRawComponentType() {
        return this.getRawReturnComponentType();
    }

    public Class getGetterRawKeyComponentType() {
        return this.getRawReturnKeyComponentType();
    }

    public void invokeSetter(Object target, Object argument) throws IllegalAccessException, InvocationTargetException {
        this.method.invoke(target, argument);
    }

    public Class getSetterRawType() {
        return this.getRawParameterTypes()[0];
    }

    public String toString() {
        return this.classDescriptor.getType().getSimpleName() + '#' + this.method.getName() + "()";
    }
}

