/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import java.io.File;
import java.io.IOException;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import jodd.io.FileUtil;
import jodd.typeconverter.TypeConversionException;
import jodd.typeconverter.TypeConverter;
import jodd.typeconverter.TypeConverterManagerBean;
import jodd.typeconverter.impl.ArrayConverter;
import jodd.util.StringUtil;
import jodd.util.collection.ByteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteArrayConverter
implements TypeConverter<byte[]> {
    protected final TypeConverterManagerBean typeConverterManagerBean;

    public ByteArrayConverter(TypeConverterManagerBean typeConverterManagerBean) {
        this.typeConverterManagerBean = typeConverterManagerBean;
    }

    @Override
    public byte[] convert(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        if (!valueClass.isArray()) {
            return this.convertValueToArray(value);
        }
        return this.convertArrayToArray(value);
    }

    protected byte convertType(Object value) {
        return this.typeConverterManagerBean.convertType(value, Byte.TYPE);
    }

    protected byte[] convertToSingleElementArray(Object value) {
        return new byte[]{this.convertType(value)};
    }

    protected byte[] convertValueToArray(Object value) {
        if (value instanceof Blob) {
            Blob blob = (Blob)value;
            try {
                long length = blob.length();
                if (length > Integer.MAX_VALUE) {
                    throw new TypeConversionException("Blob is too big.");
                }
                return blob.getBytes(1L, (int)length);
            }
            catch (SQLException sex) {
                throw new TypeConversionException(value, (Throwable)sex);
            }
        }
        if (value instanceof File) {
            try {
                return FileUtil.readBytes((File)((File)value));
            }
            catch (IOException ioex) {
                throw new TypeConversionException(value, (Throwable)ioex);
            }
        }
        if (value instanceof List) {
            List list = (List)value;
            byte[] target = new byte[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Object element = list.get(i);
                target[i] = this.convertType(element);
            }
            return target;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            byte[] target = new byte[collection.size()];
            int i = 0;
            for (Object element : collection) {
                target[i] = this.convertType(element);
                ++i;
            }
            return target;
        }
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            ByteArrayList byteArrayList = new ByteArrayList();
            for (Object element : iterable) {
                byte convertedValue = this.convertType(element);
                byteArrayList.add(convertedValue);
            }
            return byteArrayList.toArray();
        }
        if (value instanceof CharSequence) {
            String[] strings = StringUtil.splitc((String)value.toString(), (char[])ArrayConverter.NUMBER_DELIMITERS);
            return this.convertArrayToArray(strings);
        }
        return this.convertToSingleElementArray(value);
    }

    protected byte[] convertArrayToArray(Object value) {
        byte[] result;
        Class<?> valueComponentType = value.getClass().getComponentType();
        if (valueComponentType == Byte.TYPE) {
            return (byte[])value;
        }
        if (valueComponentType.isPrimitive()) {
            result = this.convertPrimitiveArrayToArray(value, valueComponentType);
        } else {
            Object[] array = (Object[])value;
            result = new byte[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = this.convertType(array[i]);
            }
        }
        return result;
    }

    protected byte[] convertPrimitiveArrayToArray(Object value, Class primitiveComponentType) {
        byte[] result;
        block9: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block8: {
                                    result = null;
                                    if (primitiveComponentType == byte[].class) {
                                        return (byte[])value;
                                    }
                                    if (primitiveComponentType != Integer.TYPE) break block8;
                                    int[] array = (int[])value;
                                    result = new byte[array.length];
                                    for (int i = 0; i < array.length; ++i) {
                                        result[i] = (byte)array[i];
                                    }
                                    break block9;
                                }
                                if (primitiveComponentType != Long.TYPE) break block10;
                                long[] array = (long[])value;
                                result = new byte[array.length];
                                for (int i = 0; i < array.length; ++i) {
                                    result[i] = (byte)array[i];
                                }
                                break block9;
                            }
                            if (primitiveComponentType != Float.TYPE) break block11;
                            float[] array = (float[])value;
                            result = new byte[array.length];
                            for (int i = 0; i < array.length; ++i) {
                                result[i] = (byte)array[i];
                            }
                            break block9;
                        }
                        if (primitiveComponentType != Double.TYPE) break block12;
                        double[] array = (double[])value;
                        result = new byte[array.length];
                        for (int i = 0; i < array.length; ++i) {
                            result[i] = (byte)array[i];
                        }
                        break block9;
                    }
                    if (primitiveComponentType != Short.TYPE) break block13;
                    short[] array = (short[])value;
                    result = new byte[array.length];
                    for (int i = 0; i < array.length; ++i) {
                        result[i] = (byte)array[i];
                    }
                    break block9;
                }
                if (primitiveComponentType != Character.TYPE) break block14;
                char[] array = (char[])value;
                result = new byte[array.length];
                for (int i = 0; i < array.length; ++i) {
                    result[i] = (byte)array[i];
                }
                break block9;
            }
            if (primitiveComponentType != Boolean.TYPE) break block9;
            boolean[] array = (boolean[])value;
            result = new byte[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = (byte)(array[i] ? 1 : 0);
            }
        }
        return result;
    }
}

