/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jodd.typeconverter.TypeConverter;
import jodd.typeconverter.TypeConverterManager;
import jodd.typeconverter.impl.ArrayConverter;
import jodd.util.StringUtil;

public class BooleanArrayConverter
implements TypeConverter<boolean[]> {
    protected final TypeConverterManager typeConverterManager;

    public BooleanArrayConverter(TypeConverterManager typeConverterManager) {
        this.typeConverterManager = typeConverterManager;
    }

    @Override
    public boolean[] convert(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        if (!valueClass.isArray()) {
            return this.convertValueToArray(value);
        }
        return this.convertArrayToArray(value);
    }

    protected boolean convertType(Object value) {
        return this.typeConverterManager.convertType(value, Boolean.TYPE);
    }

    protected boolean[] convertToSingleElementArray(Object value) {
        return new boolean[]{this.convertType(value)};
    }

    protected boolean[] convertValueToArray(Object value) {
        if (value instanceof List) {
            List list = (List)value;
            boolean[] target = new boolean[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Object element = list.get(i);
                target[i] = this.convertType(element);
            }
            return target;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            boolean[] target = new boolean[collection.size()];
            int i = 0;
            for (Object element : collection) {
                target[i] = this.convertType(element);
                ++i;
            }
            return target;
        }
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            ArrayList<Boolean> booleanArrayList = new ArrayList<Boolean>();
            for (Object element : iterable) {
                boolean convertedValue = this.convertType(element);
                booleanArrayList.add(convertedValue);
            }
            boolean[] array = new boolean[booleanArrayList.size()];
            for (int i = 0; i < booleanArrayList.size(); ++i) {
                Boolean b = (Boolean)booleanArrayList.get(i);
                array[i] = b;
            }
            return array;
        }
        if (value instanceof CharSequence) {
            String[] strings = StringUtil.splitc((String)value.toString(), (char[])ArrayConverter.NUMBER_DELIMITERS);
            return this.convertArrayToArray(strings);
        }
        return this.convertToSingleElementArray(value);
    }

    protected boolean[] convertArrayToArray(Object value) {
        boolean[] result;
        Class<?> valueComponentType = value.getClass().getComponentType();
        if (valueComponentType.isPrimitive()) {
            result = this.convertPrimitiveArrayToArray(value, valueComponentType);
        } else {
            Object[] array = (Object[])value;
            result = new boolean[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = this.convertType(array[i]);
            }
        }
        return result;
    }

    protected boolean[] convertPrimitiveArrayToArray(Object value, Class primitiveComponentType) {
        boolean[] result;
        block9: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block8: {
                                    result = null;
                                    if (primitiveComponentType == Boolean.TYPE) {
                                        return (boolean[])value;
                                    }
                                    if (primitiveComponentType != Integer.TYPE) break block8;
                                    int[] array = (int[])value;
                                    result = new boolean[array.length];
                                    for (int i = 0; i < array.length; ++i) {
                                        result[i] = array[i] != 0;
                                    }
                                    break block9;
                                }
                                if (primitiveComponentType != Long.TYPE) break block10;
                                long[] array = (long[])value;
                                result = new boolean[array.length];
                                for (int i = 0; i < array.length; ++i) {
                                    result[i] = array[i] != 0L;
                                }
                                break block9;
                            }
                            if (primitiveComponentType != Float.TYPE) break block11;
                            float[] array = (float[])value;
                            result = new boolean[array.length];
                            for (int i = 0; i < array.length; ++i) {
                                result[i] = array[i] != 0.0f;
                            }
                            break block9;
                        }
                        if (primitiveComponentType != Double.TYPE) break block12;
                        double[] array = (double[])value;
                        result = new boolean[array.length];
                        for (int i = 0; i < array.length; ++i) {
                            result[i] = array[i] != 0.0;
                        }
                        break block9;
                    }
                    if (primitiveComponentType != Short.TYPE) break block13;
                    short[] array = (short[])value;
                    result = new boolean[array.length];
                    for (int i = 0; i < array.length; ++i) {
                        result[i] = array[i] != 0;
                    }
                    break block9;
                }
                if (primitiveComponentType != Byte.TYPE) break block14;
                byte[] array = (byte[])value;
                result = new boolean[array.length];
                for (int i = 0; i < array.length; ++i) {
                    result[i] = array[i] != 0;
                }
                break block9;
            }
            if (primitiveComponentType != Character.TYPE) break block9;
            char[] array = (char[])value;
            result = new boolean[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = array[i] != '\u0000';
            }
        }
        return result;
    }
}

