/*
 * Decompiled with CFR 0.152.
 */
package jodd.bean;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import jodd.bean.BeanUtil;
import jodd.bean.JoddBean;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.FieldDescriptor;
import jodd.introspector.MethodDescriptor;
import jodd.introspector.PropertyDescriptor;
import jodd.util.inex.InExRuleMatcher;
import jodd.util.inex.InExRules;

public abstract class BeanVisitor
implements InExRuleMatcher<String, String> {
    protected Object source;
    protected InExRules<String, String, String> rules = new InExRules((InExRuleMatcher)this);
    protected boolean declared;
    protected boolean ignoreNullValues;
    protected boolean includeFields;
    protected boolean blacklist = true;
    protected boolean isSourceMap = false;

    protected String[] getAllBeanPropertyNames(Class type, boolean declared) {
        ClassDescriptor classDescriptor = JoddBean.defaults().getClassIntrospector().lookup(type);
        PropertyDescriptor[] propertyDescriptors = classDescriptor.getAllPropertyDescriptors();
        ArrayList<String> names = new ArrayList<String>(propertyDescriptors.length);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            FieldDescriptor field;
            MethodDescriptor getter = propertyDescriptor.getReadMethodDescriptor();
            if (getter != null) {
                if (!getter.matchDeclared(declared)) continue;
                names.add(propertyDescriptor.getName());
                continue;
            }
            if (!this.includeFields || (field = propertyDescriptor.getFieldDescriptor()) == null || !field.matchDeclared(declared)) continue;
            names.add(field.getName());
        }
        return names.toArray(new String[names.size()]);
    }

    protected String[] resolveProperties(Object bean, boolean declared) {
        String[] properties;
        if (bean instanceof Map) {
            Set keys = ((Map)bean).keySet();
            properties = new String[keys.size()];
            int ndx = 0;
            for (Object key : keys) {
                properties[ndx] = key.toString();
                ++ndx;
            }
        } else {
            properties = this.getAllBeanPropertyNames(bean.getClass(), declared);
        }
        return properties;
    }

    public void visit() {
        String[] properties;
        for (String name : properties = this.resolveProperties(this.source, this.declared)) {
            Object value;
            if (name == null || !this.rules.match((Object)name, this.blacklist)) continue;
            String propertyName = name;
            if (this.isSourceMap) {
                propertyName = "[" + name + "]";
            }
            if ((value = this.declared ? BeanUtil.declared.getProperty(this.source, propertyName) : BeanUtil.pojo.getProperty(this.source, propertyName)) == null && this.ignoreNullValues) continue;
            this.visitProperty(name, value);
        }
    }

    protected abstract boolean visitProperty(String var1, Object var2);

    public boolean accept(String propertyName, String rule, boolean include) {
        return propertyName.equals(rule);
    }
}

