/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jodd.bean.JoddBean;
import jodd.typeconverter.TypeConversionException;
import jodd.typeconverter.TypeConverter;
import jodd.typeconverter.TypeConverterManager;
import jodd.util.CsvUtil;

public class CollectionConverter<T>
implements TypeConverter<Collection<T>> {
    protected final TypeConverterManager typeConverterManager;
    protected final Class<? extends Collection> collectionType;
    protected final Class<T> targetComponentType;

    public CollectionConverter(Class<? extends Collection> collectionType, Class<T> targetComponentType) {
        this(JoddBean.defaults().getTypeConverterManager(), collectionType, targetComponentType);
    }

    public CollectionConverter(TypeConverterManager typeConverterManager, Class<? extends Collection> collectionType, Class<T> targetComponentType) {
        this.typeConverterManager = typeConverterManager;
        this.collectionType = collectionType;
        this.targetComponentType = targetComponentType;
    }

    @Override
    public Collection<T> convert(Object value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Collection)) {
            return this.convertValueToCollection(value);
        }
        return this.convertCollectionToCollection((Collection)value);
    }

    protected T convertType(Object value) {
        return this.typeConverterManager.convertType(value, this.targetComponentType);
    }

    protected Collection<T> createCollection(int length) {
        if (this.collectionType.isInterface()) {
            if (this.collectionType == List.class) {
                if (length > 0) {
                    return new ArrayList(length);
                }
                return new ArrayList();
            }
            if (this.collectionType == Set.class) {
                if (length > 0) {
                    return new HashSet(length);
                }
                return new HashSet();
            }
            throw new TypeConversionException("Unknown collection: " + this.collectionType.getName());
        }
        if (length > 0) {
            try {
                Constructor<? extends Collection> ctor = this.collectionType.getConstructor(Integer.TYPE);
                return ctor.newInstance(length);
            }
            catch (Exception ctor) {
                // empty catch block
            }
        }
        try {
            return this.collectionType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new TypeConversionException(ex);
        }
    }

    protected Collection<T> convertToSingleElementCollection(Object value) {
        Collection<T> collection = this.createCollection(0);
        collection.add(value);
        return collection;
    }

    protected Collection<T> convertValueToCollection(Object value) {
        Class<?> type;
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            Collection<T> collection = this.createCollection(0);
            for (Object element : iterable) {
                collection.add(this.convertType(element));
            }
            return collection;
        }
        if (value instanceof CharSequence) {
            value = CsvUtil.toStringArray((String)value.toString());
        }
        if ((type = value.getClass()).isArray()) {
            Class<?> componentType = type.getComponentType();
            if (componentType.isPrimitive()) {
                return this.convertPrimitiveArrayToCollection(value, componentType);
            }
            Object[] array = value;
            Collection<T> result = this.createCollection(array.length);
            for (Object a : array) {
                result.add(this.convertType(a));
            }
            return result;
        }
        return this.convertToSingleElementCollection(value);
    }

    protected Collection<T> convertCollectionToCollection(Collection value) {
        Collection<T> collection = this.createCollection(value.size());
        for (Object v : value) {
            collection.add(this.convertType(v));
        }
        return collection;
    }

    protected Collection<T> convertPrimitiveArrayToCollection(Object value, Class primitiveComponentType) {
        Collection<T> result;
        block9: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block8: {
                                        result = null;
                                        if (primitiveComponentType != Integer.TYPE) break block8;
                                        int[] array = (int[])value;
                                        result = this.createCollection(array.length);
                                        for (int a : array) {
                                            result.add(this.convertType(a));
                                        }
                                        break block9;
                                    }
                                    if (primitiveComponentType != Long.TYPE) break block10;
                                    long[] array = (long[])value;
                                    result = this.createCollection(array.length);
                                    for (long a : array) {
                                        result.add(this.convertType(a));
                                    }
                                    break block9;
                                }
                                if (primitiveComponentType != Float.TYPE) break block11;
                                float[] array = (float[])value;
                                result = this.createCollection(array.length);
                                for (float a : array) {
                                    result.add(this.convertType(Float.valueOf(a)));
                                }
                                break block9;
                            }
                            if (primitiveComponentType != Double.TYPE) break block12;
                            double[] array = (double[])value;
                            result = this.createCollection(array.length);
                            for (double a : array) {
                                result.add(this.convertType(a));
                            }
                            break block9;
                        }
                        if (primitiveComponentType != Short.TYPE) break block13;
                        short[] array = (short[])value;
                        result = this.createCollection(array.length);
                        for (short a : array) {
                            result.add(this.convertType(a));
                        }
                        break block9;
                    }
                    if (primitiveComponentType != Byte.TYPE) break block14;
                    byte[] array = (byte[])value;
                    result = this.createCollection(array.length);
                    for (byte a : array) {
                        result.add(this.convertType(a));
                    }
                    break block9;
                }
                if (primitiveComponentType != Character.TYPE) break block15;
                char[] array = (char[])value;
                result = this.createCollection(array.length);
                for (char a : array) {
                    result.add(this.convertType(Character.valueOf(a)));
                }
                break block9;
            }
            if (primitiveComponentType != Boolean.TYPE) break block9;
            boolean[] array = (boolean[])value;
            result = this.createCollection(array.length);
            for (boolean a : array) {
                result.add(this.convertType(a));
            }
        }
        return result;
    }
}

