/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import java.util.Calendar;
import java.util.Date;
import jodd.time.JulianDate;
import jodd.typeconverter.TypeConversionException;
import jodd.typeconverter.TypeConverter;
import jodd.util.StringUtil;

public class SqlDateConverter
implements TypeConverter<java.sql.Date> {
    @Override
    public java.sql.Date convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof java.sql.Date) {
            return (java.sql.Date)value;
        }
        if (value instanceof Calendar) {
            return new java.sql.Date(((Calendar)value).getTimeInMillis());
        }
        if (value instanceof Date) {
            return new java.sql.Date(((Date)value).getTime());
        }
        if (value instanceof JulianDate) {
            return new java.sql.Date(((JulianDate)value).toMilliseconds());
        }
        if (value instanceof Number) {
            return new java.sql.Date(((Number)value).longValue());
        }
        String stringValue = value.toString().trim();
        if (!StringUtil.containsOnlyDigits((CharSequence)stringValue)) {
            try {
                return java.sql.Date.valueOf(stringValue);
            }
            catch (IllegalArgumentException iaex) {
                throw new TypeConversionException(value, (Throwable)iaex);
            }
        }
        try {
            long milliseconds = Long.parseLong(stringValue);
            return new java.sql.Date(milliseconds);
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException(value, (Throwable)nfex);
        }
    }
}

