/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom.config;

import java.io.File;
import java.io.InputStream;
import jodd.db.oom.DbOomException;
import jodd.db.oom.DbOomManager;
import jodd.db.oom.meta.DbTable;
import jodd.io.findfile.ClassFinder;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.util.ClassLoaderUtil;

public class AutomagicDbOomConfigurator
extends ClassFinder {
    private static final Logger log = LoggerFactory.getLogger(AutomagicDbOomConfigurator.class);
    protected final byte[] dbTableAnnotationBytes = this.getTypeSignatureBytes(DbTable.class);
    protected final boolean registerAsEntities;
    protected DbOomManager dbOomManager;
    protected long elapsed;

    public AutomagicDbOomConfigurator(boolean registerAsEntities) {
        this.registerAsEntities = registerAsEntities;
    }

    public AutomagicDbOomConfigurator() {
        this(true);
    }

    public long getElapsed() {
        return this.elapsed;
    }

    public void configure(DbOomManager dbOomManager, File[] classpath) {
        this.dbOomManager = dbOomManager;
        this.rulesEntries.smartMode();
        this.elapsed = System.currentTimeMillis();
        try {
            this.scanPaths(classpath);
        }
        catch (Exception ex) {
            throw new DbOomException("Scan classpath error", ex);
        }
        this.elapsed = System.currentTimeMillis() - this.elapsed;
        if (log.isInfoEnabled()) {
            log.info("DbOomManager configured in " + this.elapsed + " ms. Total entities: " + dbOomManager.getTotalNames());
        }
    }

    public void configure(DbOomManager dbOomManager) {
        this.configure(dbOomManager, ClassLoaderUtil.getDefaultClasspath());
    }

    protected void onEntry(ClassFinder.EntryData entryData) {
        Class beanClass;
        String entryName = entryData.getName();
        InputStream inputStream = entryData.openInputStream();
        if (!this.isTypeSignatureInUse(inputStream, this.dbTableAnnotationBytes)) {
            return;
        }
        try {
            beanClass = this.loadClass(entryName);
        }
        catch (ClassNotFoundException cnfex) {
            throw new DbOomException("Entry class not found: " + entryName, cnfex);
        }
        if (beanClass == null) {
            return;
        }
        DbTable dbTable = beanClass.getAnnotation(DbTable.class);
        if (dbTable == null) {
            return;
        }
        if (this.registerAsEntities) {
            this.dbOomManager.registerEntity(beanClass);
        } else {
            this.dbOomManager.registerType(beanClass);
        }
    }
}

