/*
 * Decompiled with CFR 0.152.
 */
package jodd.http;

import java.util.LinkedHashMap;
import java.util.Map;
import jodd.http.Cookie;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;

public class HttpBrowser {
    protected HttpRequest httpRequest;
    protected HttpResponse httpResponse;
    protected Map<String, Cookie> cookies = new LinkedHashMap<String, Cookie>();

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public String getPage() {
        if (this.httpResponse == null) {
            return null;
        }
        return this.httpResponse.bodyText();
    }

    public void sendRequest(HttpRequest httpRequest) {
        while (true) {
            String newPath;
            this.httpRequest = httpRequest;
            this.httpResponse = null;
            this.addCookies(httpRequest);
            this.httpResponse = httpRequest.send();
            this.readCookies(this.httpResponse);
            int statusCode = this.httpResponse.statusCode();
            if (statusCode == 301) {
                newPath = this.httpResponse.header("location");
                httpRequest = HttpRequest.get(newPath);
                continue;
            }
            if (statusCode == 302 || statusCode == 303) {
                newPath = this.httpResponse.header("location");
                httpRequest = HttpRequest.get(newPath);
                continue;
            }
            if (statusCode != 307) break;
            newPath = this.httpResponse.header("location");
            String originalMethod = httpRequest.method();
            httpRequest = new HttpRequest().method(originalMethod).set(newPath);
        }
    }

    protected void readCookies(HttpResponse httpResponse) {
        String[] newCookies = httpResponse.headers("set-cookie");
        if (newCookies != null) {
            for (String cookieValue : newCookies) {
                Cookie cookie = new Cookie(cookieValue);
                this.cookies.put(cookie.getName(), cookie);
            }
        }
    }

    protected void addCookies(HttpRequest httpRequest) {
        StringBuilder cookieString = new StringBuilder();
        boolean first = true;
        if (!this.cookies.isEmpty()) {
            for (Cookie cookie : this.cookies.values()) {
                if (!first) {
                    cookieString.append("; ");
                }
                first = false;
                cookieString.append(cookie.getName());
                cookieString.append('=');
                cookieString.append(cookie.getValue());
            }
            httpRequest.header("cookie", cookieString.toString(), true);
        }
    }
}

