/*
 * Decompiled with CFR 0.152.
 */
package jodd.json;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.FieldDescriptor;
import jodd.introspector.Getter;
import jodd.introspector.PropertyDescriptor;
import jodd.introspector.Setter;
import jodd.json.JsonException;
import jodd.json.Path;
import jodd.typeconverter.TypeConverterManager;
import jodd.util.CharUtil;
import jodd.util.UnsafeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonParser {
    private static final char[] T_RUE = new char[]{'r', 'u', 'e'};
    private static final char[] F_ALSE = new char[]{'a', 'l', 's', 'e'};
    private static final char[] N_ULL = new char[]{'u', 'l', 'l'};
    private static final String VALUES = "values";
    protected int ndx = 0;
    protected char[] input;
    protected int total;
    protected Path path;
    protected Map<Path, Class> mappings;
    protected char[] text = new char[512];
    protected int textLen;
    private static BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    private static BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);

    protected void reset() {
        this.ndx = 0;
        this.textLen = 0;
        this.path = new Path();
    }

    public JsonParser map(Class target) {
        return this.map(null, target);
    }

    public JsonParser map(String path, Class target) {
        if (this.mappings == null) {
            this.mappings = new HashMap<Path, Class>();
        }
        this.mappings.put(Path.parse(path), target);
        return this;
    }

    protected Class replaceWithMappedTypeForPath(Class target) {
        if (this.mappings == null) {
            return target;
        }
        Class newType = this.mappings.get(this.path);
        if (newType == null) {
            return target;
        }
        return newType;
    }

    public <T> T parse(String input, Class<T> targetType) {
        this.map(targetType);
        return (T)this.parse(input);
    }

    public Object parse(String input) {
        char[] chars = UnsafeUtil.getChars((String)input);
        return this.parse(chars);
    }

    public <T> T parse(char[] input, Class<T> targetType) {
        this.map(targetType);
        return (T)this.parse(input);
    }

    public Object parse(char[] input) {
        Object value;
        this.input = input;
        this.total = input.length;
        this.reset();
        this.skipWhiteSpaces();
        Class targetType = this.replaceWithMappedTypeForPath(null);
        try {
            value = this.parseValue(targetType, null);
        }
        catch (IndexOutOfBoundsException iofbex) {
            this.syntaxError("End of JSON");
            return null;
        }
        this.skipWhiteSpaces();
        if (this.ndx != this.total) {
            this.syntaxError("Trailing chars");
            return null;
        }
        return value;
    }

    protected Object parseValue(Class targetType, Class componentType) {
        char c = this.input[this.ndx];
        switch (c) {
            case '\"': {
                ++this.ndx;
                String string = this.parseStringContent();
                if (targetType != null) {
                    return this.convertType(string, targetType);
                }
                return string;
            }
            case '{': {
                ++this.ndx;
                return this.parseObjectContent(targetType, componentType);
            }
            case '[': {
                ++this.ndx;
                return this.parseArrayContent(targetType, componentType);
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                Number number = this.parseNumber();
                if (targetType != null) {
                    return this.convertType(number, targetType);
                }
                return number;
            }
            case 'n': {
                ++this.ndx;
                if (!this.match(N_ULL)) break;
                return null;
            }
            case 't': {
                ++this.ndx;
                if (!this.match(T_RUE)) break;
                if (targetType != null) {
                    return this.convertType(Boolean.TRUE, targetType);
                }
                return Boolean.TRUE;
            }
            case 'f': {
                ++this.ndx;
                if (!this.match(F_ALSE)) break;
                if (targetType != null) {
                    return this.convertType(Boolean.FALSE, targetType);
                }
                return Boolean.FALSE;
            }
        }
        this.syntaxError("Invalid char: " + this.input[this.ndx]);
        return null;
    }

    protected String parseString() {
        this.consume('\"');
        return this.parseStringContent();
    }

    protected String parseStringContent() {
        char c;
        int startNdx = this.ndx;
        while (true) {
            if ((c = this.input[this.ndx]) == '\"') {
                ++this.ndx;
                return new String(this.input, startNdx, this.ndx - startNdx - 1);
            }
            if (c == '\\') break;
            ++this.ndx;
        }
        this.textLen = this.ndx - startNdx;
        if (this.textLen >= this.text.length) {
            this.grow();
        }
        System.arraycopy(this.input, startNdx, this.text, 0, this.textLen);
        while (true) {
            if ((c = this.input[this.ndx]) == '\"') {
                ++this.ndx;
                String str = new String(this.text, 0, this.textLen);
                this.textLen = 0;
                return str;
            }
            if (c == '\\') {
                ++this.ndx;
                c = this.input[this.ndx];
                switch (c) {
                    case '\"': {
                        c = '\"';
                        break;
                    }
                    case '\\': {
                        c = '\\';
                        break;
                    }
                    case '/': {
                        c = '/';
                        break;
                    }
                    case 'b': {
                        c = '\b';
                        break;
                    }
                    case 'f': {
                        c = '\f';
                        break;
                    }
                    case 'n': {
                        c = '\n';
                        break;
                    }
                    case 'r': {
                        c = '\r';
                        break;
                    }
                    case 't': {
                        c = '\t';
                        break;
                    }
                    case 'u': {
                        ++this.ndx;
                        c = this.parseUnicode();
                        break;
                    }
                    default: {
                        this.syntaxError("Invalid escape char: " + c);
                    }
                }
            }
            this.text[this.textLen] = c;
            ++this.textLen;
            if (this.textLen >= this.text.length) {
                this.grow();
            }
            ++this.ndx;
        }
    }

    protected void grow() {
        int newSize = this.text.length << 1;
        char[] newText = new char[newSize];
        if (this.textLen > 0) {
            System.arraycopy(this.text, 0, newText, 0, this.textLen);
        }
        this.text = newText;
    }

    protected char parseUnicode() {
        int i0 = CharUtil.hex2int((char)this.input[this.ndx++]);
        int i1 = CharUtil.hex2int((char)this.input[this.ndx++]);
        int i2 = CharUtil.hex2int((char)this.input[this.ndx++]);
        int i3 = CharUtil.hex2int((char)this.input[this.ndx]);
        return (char)((i0 << 12) + (i1 << 8) + (i2 << 4) + i3);
    }

    protected Number parseNumber() {
        long longNumber;
        int startIndex = this.ndx;
        char c = this.input[this.ndx];
        boolean isDouble = false;
        boolean isExp = false;
        if (c == '-') {
            ++this.ndx;
        }
        while (!this.isEOF()) {
            c = this.input[this.ndx];
            if (CharUtil.isDigit((char)c)) {
                ++this.ndx;
                continue;
            }
            if (c <= ' ' || c == ',' || c == '}' || c == ']') break;
            if (c == '.') {
                isDouble = true;
            } else if (c == 'e' || c == 'E') {
                isExp = true;
            }
            ++this.ndx;
        }
        String value = String.valueOf(this.input, startIndex, this.ndx - startIndex);
        if (isDouble) {
            return Double.valueOf(value);
        }
        if (isExp) {
            longNumber = Double.valueOf(value).longValue();
        } else if (value.length() >= 19) {
            BigInteger bigInteger = new BigInteger(value);
            if (JsonParser.isGreaterThenLong(bigInteger)) {
                return bigInteger;
            }
            longNumber = bigInteger.longValue();
        } else {
            longNumber = Long.parseLong(value);
        }
        if (longNumber > 0L && longNumber <= Integer.MAX_VALUE || longNumber < 0L && longNumber >= Integer.MIN_VALUE) {
            return (int)longNumber;
        }
        return longNumber;
    }

    private static boolean isGreaterThenLong(BigInteger bigInteger) {
        if (bigInteger.compareTo(MAX_LONG) == 1) {
            return true;
        }
        return bigInteger.compareTo(MIN_LONG) == -1;
    }

    protected Object parseArrayContent(Class targetType, Class componentType) {
        targetType = this.replaceWithMappedTypeForPath(targetType);
        this.path.push(VALUES);
        componentType = this.replaceWithMappedTypeForPath(componentType);
        this.path.pop();
        Object target = this.newArrayInstance(targetType);
        ClassDescriptor cd = ClassIntrospector.lookup(target.getClass());
        boolean isList = cd.isList();
        block4: while (true) {
            this.skipWhiteSpaces();
            char c = this.input[this.ndx];
            if (c == ']') {
                ++this.ndx;
                return target;
            }
            Object value = this.parseValue(componentType, null);
            if (componentType != null) {
                value = this.convertType(value, componentType);
            }
            if (isList) {
                ((List)target).add(value);
            }
            this.skipWhiteSpaces();
            c = this.input[this.ndx];
            switch (c) {
                case ']': {
                    ++this.ndx;
                    break block4;
                }
                case ',': {
                    ++this.ndx;
                    continue block4;
                }
                default: {
                    this.syntaxError("Invalid char: expected ] or ,");
                    continue block4;
                }
            }
            break;
        }
        return target;
    }

    protected Object parseObjectContent(Class targetType, Class valueType) {
        targetType = this.replaceWithMappedTypeForPath(targetType);
        Object target = this.newObjectInstance(targetType);
        block4: while (true) {
            Object value;
            this.skipWhiteSpaces();
            char c = this.input[this.ndx];
            if (c == '}') {
                ++this.ndx;
                break;
            }
            String key = this.parseString();
            this.skipWhiteSpaces();
            this.consume(':');
            this.skipWhiteSpaces();
            PropertyDescriptor pd = null;
            Class propertyType = null;
            Class componentType = null;
            if (targetType != null && (pd = this.resolveSimpleProperty(targetType, key)) != null) {
                propertyType = pd.getType();
                componentType = this.resolveComponentType(pd);
            }
            if (pd != null) {
                this.path.push(key);
                value = this.parseValue(propertyType, componentType);
                this.path.pop();
                this.injectValueIntoObject(target, pd, value);
            } else {
                this.path.push(VALUES);
                value = this.parseValue(valueType, null);
                this.path.pop();
                ((Map)target).put(key, value);
            }
            this.skipWhiteSpaces();
            c = this.input[this.ndx];
            switch (c) {
                case '}': {
                    ++this.ndx;
                    break block4;
                }
                case ',': {
                    ++this.ndx;
                    continue block4;
                }
                default: {
                    this.syntaxError("Invalid char: expected } or ,");
                    continue block4;
                }
            }
            break;
        }
        return target;
    }

    protected void consume(char c) {
        if (this.input[this.ndx] != c) {
            this.syntaxError("Invalid char: expected " + c);
        }
        ++this.ndx;
    }

    protected boolean isEOF() {
        return this.ndx >= this.total;
    }

    protected final void skipWhiteSpaces() {
        while (!this.isEOF()) {
            if (this.input[this.ndx] > ' ') {
                return;
            }
            ++this.ndx;
        }
        return;
    }

    protected final boolean match(char[] target) {
        for (char c : target) {
            if (this.input[this.ndx] != c) {
                return false;
            }
            ++this.ndx;
        }
        return true;
    }

    protected Object newObjectInstance(Class targetType) {
        if (targetType == null) {
            return new HashMap();
        }
        if (targetType == Map.class) {
            return new HashMap();
        }
        try {
            return targetType.newInstance();
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    protected Object newArrayInstance(Class targetType) {
        if (targetType == null) {
            return new ArrayList();
        }
        if (targetType.isArray()) {
            return new ArrayList();
        }
        if (targetType == List.class) {
            return new ArrayList();
        }
        try {
            return targetType.newInstance();
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    protected PropertyDescriptor resolveSimpleProperty(Class type, String key) {
        if (type == null) {
            return null;
        }
        if (type == Map.class) {
            return null;
        }
        ClassDescriptor cd = ClassIntrospector.lookup((Class)type);
        if (cd.isMap()) {
            return null;
        }
        return cd.getPropertyDescriptor(key, true);
    }

    protected Class resolveComponentType(PropertyDescriptor pd) {
        FieldDescriptor fieldDescriptor;
        Class componentType = null;
        Getter getter = pd.getGetter(true);
        if (getter != null) {
            componentType = getter.getGetterRawComponentType();
        }
        if (componentType == null && (fieldDescriptor = pd.getFieldDescriptor()) != null) {
            componentType = fieldDescriptor.getRawComponentType();
        }
        return componentType;
    }

    protected void injectValueIntoObject(Object target, PropertyDescriptor pd, Object value) {
        Class targetClass = pd.getType();
        Object convertedValue = this.convertType(value, targetClass);
        try {
            Setter setter = pd.getSetter(true);
            if (setter != null) {
                setter.invokeSetter(target, convertedValue);
            } else {
                FieldDescriptor fd = pd.getFieldDescriptor();
                fd.getField().set(target, convertedValue);
            }
        }
        catch (Exception ex) {
            throw new JsonException(ex);
        }
    }

    protected Object convertType(Object value, Class targetType) {
        Class<?> valueClass = value.getClass();
        if (valueClass == targetType) {
            return value;
        }
        try {
            return TypeConverterManager.convertType((Object)value, (Class)targetType);
        }
        catch (Exception ex) {
            throw new JsonException("Type conversion failed", ex);
        }
    }

    protected void syntaxError(String message) {
        int to;
        int from = this.ndx - 5;
        if (from < 0) {
            from = 0;
        }
        if ((to = this.ndx + 5) > this.input.length) {
            to = this.input.length;
        }
        String str = String.valueOf(this.input, from, to - from);
        throw new JsonException("Syntax error: " + message + "\noffset: " + this.ndx + " near: \"..." + str + "...\"");
    }
}

