/*
 * Decompiled with CFR 0.152.
 */
package jodd.json;

import jodd.util.StringUtil;

public class Path {
    protected String[] paths = new String[8];
    protected int index = 0;

    public static Path parse(String path) {
        if (path == null) {
            return new Path();
        }
        return new Path(StringUtil.splitc((String)path, (char)'.'));
    }

    public Path() {
    }

    public Path(String ... fields) {
        if (fields.length >= this.paths.length) {
            this.paths = fields;
        } else {
            System.arraycopy(fields, 0, this.paths, 0, fields.length);
            this.index = fields.length;
        }
    }

    public Path push(String field) {
        if (this.index == this.paths.length) {
            String[] newPaths = new String[this.paths.length << 1];
            System.arraycopy(this.paths, 0, newPaths, 0, this.paths.length);
            this.paths = newPaths;
        }
        this.paths[this.index] = field;
        ++this.index;
        return this;
    }

    public String pop() {
        return this.paths[--this.index];
    }

    public int length() {
        return this.index;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        boolean afterFirst = false;
        for (int i = 0; i < this.index; ++i) {
            String current = this.paths[i];
            if (afterFirst) {
                builder.append('.');
            }
            builder.append(current);
            afterFirst = true;
        }
        builder.append(']');
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Path path1 = (Path)o;
        int length = path1.length();
        if (this.length() != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            String o1 = path1.paths[i];
            String o2 = this.paths[i];
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.index; ++i) {
            String element = this.paths[i];
            result = 31 * result + (element == null ? 0 : element.hashCode());
        }
        return result;
    }
}

