/*
 * Decompiled with CFR 0.152.
 */
package jodd.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import jodd.datetime.JDateTime;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.json.TypeJsonSerializer;
import jodd.json.impl.ArraysJsonSerializer;
import jodd.json.impl.BooleanArrayJsonSerializer;
import jodd.json.impl.BooleanJsonSerializer;
import jodd.json.impl.ByteArrayJsonSerializer;
import jodd.json.impl.CalendarJsonSerializer;
import jodd.json.impl.CharSequenceJsonSerializer;
import jodd.json.impl.CharacterJsonSerializer;
import jodd.json.impl.ClassJsonSerializer;
import jodd.json.impl.DateJsonSerializer;
import jodd.json.impl.DoubleArrayJsonSerializer;
import jodd.json.impl.EnumJsonSerializer;
import jodd.json.impl.FloatArrayJsonSerializer;
import jodd.json.impl.IntArrayJsonSerializer;
import jodd.json.impl.IterableJsonSerializer;
import jodd.json.impl.JDateTimeSerializer;
import jodd.json.impl.LongArrayJsonSerializer;
import jodd.json.impl.MapJsonSerializer;
import jodd.json.impl.NumberJsonSerializer;
import jodd.json.impl.ObjectJsonSerializer;
import jodd.util.collection.ClassMap;

public class TypeJsonSerializerMap {
    protected final ClassMap<TypeJsonSerializer> map = new ClassMap();
    protected final ClassMap<TypeJsonSerializer> cache = new ClassMap();

    public TypeJsonSerializerMap(boolean registerDefaults) {
        if (registerDefaults) {
            this.registerDefaults();
        }
    }

    public void registerDefaults() {
        this.map.put(Object.class, (Object)new ObjectJsonSerializer());
        this.map.put(Map.class, (Object)new MapJsonSerializer());
        this.map.put(Iterable.class, (Object)new IterableJsonSerializer());
        this.map.put(int[].class, (Object)new IntArrayJsonSerializer());
        this.map.put(long[].class, (Object)new LongArrayJsonSerializer());
        this.map.put(double[].class, (Object)new DoubleArrayJsonSerializer());
        this.map.put(float[].class, (Object)new FloatArrayJsonSerializer());
        this.map.put(boolean[].class, (Object)new BooleanArrayJsonSerializer());
        this.map.put(byte[].class, (Object)new ByteArrayJsonSerializer());
        this.map.put(Integer[].class, (Object)new ArraysJsonSerializer<Integer>(){

            protected int getLength(Integer[] array) {
                return array.length;
            }

            protected Integer get(Integer[] array, int index) {
                return array[index];
            }
        });
        this.map.put(Long[].class, (Object)new ArraysJsonSerializer<Long>(){

            protected int getLength(Long[] array) {
                return array.length;
            }

            protected Long get(Long[] array, int index) {
                return array[index];
            }
        });
        this.map.put(Arrays.class, new ArraysJsonSerializer());
        TypeJsonSerializer<CharSequence> jsonSerializer = new CharSequenceJsonSerializer();
        this.map.put(String.class, (Object)jsonSerializer);
        this.map.put(StringBuilder.class, (Object)jsonSerializer);
        this.map.put(CharSequence.class, (Object)jsonSerializer);
        jsonSerializer = new NumberJsonSerializer();
        this.map.put(Number.class, (Object)jsonSerializer);
        this.map.put(Integer.class, (Object)jsonSerializer);
        this.map.put(Integer.TYPE, (Object)jsonSerializer);
        this.map.put(Long.class, (Object)jsonSerializer);
        this.map.put(Long.TYPE, (Object)jsonSerializer);
        this.map.put(Double.class, (Object)jsonSerializer);
        this.map.put(Double.TYPE, (Object)jsonSerializer);
        this.map.put(Float.class, (Object)jsonSerializer);
        this.map.put(Float.TYPE, (Object)jsonSerializer);
        this.map.put(BigInteger.class, (Object)jsonSerializer);
        this.map.put(BigDecimal.class, (Object)jsonSerializer);
        this.map.put(Boolean.class, (Object)new BooleanJsonSerializer());
        this.map.put(Date.class, (Object)new DateJsonSerializer());
        this.map.put(Calendar.class, (Object)new CalendarJsonSerializer());
        this.map.put(JDateTime.class, (Object)new JDateTimeSerializer());
        this.map.put(Enum.class, (Object)new EnumJsonSerializer());
        jsonSerializer = new CharacterJsonSerializer();
        this.map.put(Character.class, (Object)jsonSerializer);
        this.map.put(Character.TYPE, (Object)jsonSerializer);
        this.map.put(Class.class, (Object)new ClassJsonSerializer());
        this.cache.clear();
    }

    public void register(Class type, TypeJsonSerializer typeJsonSerializer) {
        this.map.put(type, (Object)typeJsonSerializer);
        this.cache.clear();
    }

    public TypeJsonSerializer lookup(Class type) {
        TypeJsonSerializer tjs = (TypeJsonSerializer)this.cache.unsafeGet(type);
        if (tjs != null) {
            return tjs;
        }
        tjs = this._lookup(type);
        this.cache.put(type, (Object)tjs);
        return tjs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TypeJsonSerializer _lookup(Class type) {
        ClassMap<TypeJsonSerializer> classMap = this.map;
        synchronized (classMap) {
            Class[] superclasses;
            Class[] interfaces;
            TypeJsonSerializer tjs = (TypeJsonSerializer)this.map.unsafeGet(type);
            if (tjs != null) {
                return tjs;
            }
            ClassDescriptor cd = ClassIntrospector.lookup((Class)type);
            if (cd.isArray()) {
                return (TypeJsonSerializer)this.map.unsafeGet(Arrays.class);
            }
            for (Class interfaze : interfaces = cd.getAllInterfaces()) {
                tjs = (TypeJsonSerializer)this.map.unsafeGet(interfaze);
                if (tjs == null) continue;
                return tjs;
            }
            for (Class clazz : superclasses = cd.getAllSuperclasses()) {
                tjs = (TypeJsonSerializer)this.map.unsafeGet(clazz);
                if (tjs == null) continue;
                return tjs;
            }
            return (TypeJsonSerializer)this.map.unsafeGet(Object.class);
        }
    }
}

