/*
 * Decompiled with CFR 0.152.
 */
package jodd.json;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.CtorDescriptor;
import jodd.introspector.PropertyDescriptor;
import jodd.introspector.Setter;
import jodd.json.JsonException;
import jodd.json.LazyList;
import jodd.json.LazyMap;
import jodd.json.MapToBean;
import jodd.typeconverter.TypeConverterManager;

public abstract class JsonParserBase {
    protected static final Supplier<Map> HASMAP_SUPPLIER = LinkedHashMap::new;
    protected static final Supplier<Map> LAZYMAP_SUPPLIER = LazyMap::new;
    protected static final Supplier<List> ARRAYLIST_SUPPLIER = ArrayList::new;
    protected static final Supplier<List> LAZYLIST_SUPPLIER = LazyList::new;
    protected Supplier<Map> mapSupplier = HASMAP_SUPPLIER;
    protected Supplier<List> listSupplier = ARRAYLIST_SUPPLIER;
    protected List<String> classnameWhitelist;
    protected boolean strictTypes;

    public JsonParserBase(boolean strictTypes) {
        this.strictTypes = strictTypes;
    }

    protected MapToBean createMapToBean(String classMetadataName) {
        return new MapToBean(this, classMetadataName);
    }

    protected Collection<Object> newArrayInstance(Class targetType) {
        if (targetType == null || targetType == List.class || targetType == Collection.class || targetType.isArray()) {
            return this.listSupplier.get();
        }
        if (targetType == Set.class) {
            return new HashSet<Object>();
        }
        try {
            return (Collection)targetType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    protected Object newObjectInstance(Class targetType) {
        if (targetType == null || targetType == Map.class) {
            return this.mapSupplier.get();
        }
        ClassDescriptor cd = ClassIntrospector.get().lookup(targetType);
        CtorDescriptor ctorDescriptor = cd.getDefaultCtorDescriptor(true);
        if (ctorDescriptor == null) {
            throw new JsonException("Default ctor not found for: " + targetType.getName());
        }
        try {
            return ctorDescriptor.getConstructor().newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    protected void injectValueIntoObject(Object target, PropertyDescriptor pd, Object value) {
        Object convertedValue = value;
        if (value != null) {
            Class targetClass = pd.getType();
            convertedValue = this.convertType(value, targetClass);
        }
        try {
            Setter setter = pd.getSetter(true);
            if (setter != null) {
                setter.invokeSetter(target, convertedValue);
            }
        }
        catch (Exception ex) {
            throw new JsonException(ex);
        }
    }

    protected Object convertType(Object value, Class targetType) {
        Class<?> valueClass = value.getClass();
        if (valueClass == targetType) {
            return value;
        }
        try {
            return TypeConverterManager.get().convertType(value, targetType);
        }
        catch (Exception ex) {
            if (!this.strictTypes) {
                return null;
            }
            throw new JsonException("Type conversion failed", ex);
        }
    }
}

