/*
 * Decompiled with CFR 0.152.
 */
package jodd.json.meta;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import jodd.json.meta.JSON;
import jodd.util.AnnotationParser;

public class JSONAnnotationValues
implements JSON {
    protected final boolean strict;
    protected final String name;
    protected final boolean include;
    protected final Class<? extends Annotation> annotationType;

    public static AnnotationParser parserFor(Class<? extends Annotation> annotationClass) {
        return new AnnotationParser(annotationClass, JSON.class);
    }

    public static JSONAnnotationValues of(AnnotationParser annotationParser, AnnotatedElement annotatedElement) {
        if (!annotationParser.hasAnnotationOn(annotatedElement)) {
            return null;
        }
        return new JSONAnnotationValues(annotationParser.of(annotatedElement));
    }

    private JSONAnnotationValues(AnnotationParser.Reader reader) {
        this.annotationType = reader.annotationType();
        this.name = reader.readString("name", null);
        this.include = reader.readBoolean("include", true);
        this.strict = reader.readBoolean("strict", false);
    }

    @Override
    public boolean strict() {
        return this.strict;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean include() {
        return this.include;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return this.annotationType;
    }
}

