/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom;

import java.io.IOException;
import jodd.lagarto.Tag;
import jodd.lagarto.dom.LagartoDOMBuilder;
import jodd.lagarto.dom.Node;

public class Element
extends Node {
    protected final boolean voidElement;
    protected final boolean selfClosed;

    protected Element(LagartoDOMBuilder domBuilder, Tag tag, boolean voidElement, boolean selfClosed) {
        super(domBuilder, Node.NodeType.ELEMENT, tag.getName());
        this.voidElement = voidElement;
        this.selfClosed = selfClosed;
        int attrCount = tag.getAttributeCount();
        for (int i = 0; i < attrCount; ++i) {
            String key = tag.getAttributeName(i);
            String value = tag.getAttributeValue(i);
            this.setAttribute(key, value);
        }
    }

    public Element(LagartoDOMBuilder domBuilder, String name, boolean voidElement, boolean selfClosed) {
        super(domBuilder, Node.NodeType.ELEMENT, name);
        this.voidElement = voidElement;
        this.selfClosed = selfClosed;
    }

    public Element clone() {
        return this.cloneTo(new Element(this.domBuilder, this.nodeName, this.voidElement, this.selfClosed));
    }

    public boolean isVoidElement() {
        return this.voidElement;
    }

    public boolean isSelfClosed() {
        return this.selfClosed;
    }

    public void toHtml(Appendable appendable) throws IOException {
        this.getDomBuilder().getRenderer().renderElement(this, appendable);
    }

    public String toString() {
        return '<' + this.nodeName + '>';
    }
}

