/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom;

import java.nio.CharBuffer;
import java.util.List;
import jodd.lagarto.LagartoParserEngine;
import jodd.lagarto.Tag;
import jodd.lagarto.dom.CData;
import jodd.lagarto.dom.Comment;
import jodd.lagarto.dom.DOMBuilderTagVisitor;
import jodd.lagarto.dom.Document;
import jodd.lagarto.dom.DocumentType;
import jodd.lagarto.dom.Element;
import jodd.lagarto.dom.LagartoNodeHtmlRenderer;
import jodd.lagarto.dom.Text;
import jodd.lagarto.dom.XmlDeclaration;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LagartoDOMBuilder
extends LagartoParserEngine {
    public static final String[] HTML5_VOID_TAGS = new String[]{"area", "base", "br", "col", "embed", "hr", "img", "input", "keygen", "link", "menuitem", "meta", "param", "source", "track", "wbr"};
    protected boolean ignoreWhitespacesBetweenTags;
    protected boolean caseSensitive;
    protected boolean ignoreComments;
    protected boolean selfCloseVoidTags;
    protected boolean collectErrors;
    protected String conditionalCommentExpression;
    protected String[] voidTags = HTML5_VOID_TAGS;
    protected boolean impliedEndTags;
    protected LagartoNodeHtmlRenderer renderer = new LagartoNodeHtmlRenderer();
    protected List<String> errors;
    protected long elapsed;

    public LagartoDOMBuilder() {
        this.enableHtmlMode();
    }

    public LagartoNodeHtmlRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(LagartoNodeHtmlRenderer renderer) {
        this.renderer = renderer;
    }

    public boolean isIgnoreWhitespacesBetweenTags() {
        return this.ignoreWhitespacesBetweenTags;
    }

    public void setIgnoreWhitespacesBetweenTags(boolean ignoreWhitespacesBetweenTags) {
        this.ignoreWhitespacesBetweenTags = ignoreWhitespacesBetweenTags;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isIgnoreComments() {
        return this.ignoreComments;
    }

    public void setIgnoreComments(boolean ignoreComments) {
        this.ignoreComments = ignoreComments;
    }

    public String[] getVoidTags() {
        return this.voidTags;
    }

    public void setVoidTags(String ... voidTags) {
        this.voidTags = voidTags;
    }

    public boolean hasVoidTags() {
        return this.voidTags != null;
    }

    public boolean isVoidTag(String tagName) {
        if (this.voidTags == null) {
            return false;
        }
        return StringUtil.equalsOne((String)(tagName = tagName.toLowerCase()), (String[])this.voidTags) != -1;
    }

    public boolean isSelfCloseVoidTags() {
        return this.selfCloseVoidTags;
    }

    public void setSelfCloseVoidTags(boolean selfCloseVoidTags) {
        this.selfCloseVoidTags = selfCloseVoidTags;
    }

    public boolean isCollectErrors() {
        return this.collectErrors;
    }

    public void setCollectErrors(boolean collectErrors) {
        this.collectErrors = collectErrors;
    }

    public String getConditionalCommentExpression() {
        return this.conditionalCommentExpression;
    }

    public void setConditionalCommentExpression(String conditionalCommentExpression) {
        this.conditionalCommentExpression = conditionalCommentExpression;
    }

    public boolean isImpliedEndTags() {
        return this.impliedEndTags;
    }

    public void setImpliedEndTags(boolean impliedEndTags) {
        this.impliedEndTags = impliedEndTags;
    }

    public LagartoDOMBuilder enableHtmlMode() {
        this.ignoreWhitespacesBetweenTags = false;
        this.caseSensitive = false;
        this.parseSpecialTagsAsCdata = true;
        this.voidTags = HTML5_VOID_TAGS;
        this.selfCloseVoidTags = false;
        this.impliedEndTags = true;
        this.enableConditionalComments = true;
        this.conditionalCommentExpression = "if !IE";
        this.renderer.reset();
        return this;
    }

    public LagartoDOMBuilder enableXhtmlMode() {
        this.ignoreWhitespacesBetweenTags = false;
        this.caseSensitive = true;
        this.parseSpecialTagsAsCdata = false;
        this.voidTags = HTML5_VOID_TAGS;
        this.selfCloseVoidTags = true;
        this.impliedEndTags = false;
        this.enableConditionalComments = true;
        this.conditionalCommentExpression = "if !IE";
        this.renderer.reset();
        return this;
    }

    public LagartoDOMBuilder enableXmlMode() {
        this.ignoreWhitespacesBetweenTags = true;
        this.caseSensitive = true;
        this.parseSpecialTagsAsCdata = false;
        this.voidTags = null;
        this.selfCloseVoidTags = false;
        this.impliedEndTags = false;
        this.enableConditionalComments = false;
        this.conditionalCommentExpression = null;
        this.renderer.reset();
        return this;
    }

    public Document parse(CharSequence content) {
        this.initialize(CharBuffer.wrap(content));
        return this.doParse();
    }

    public Document parse(CharBuffer content) {
        this.initialize(content);
        return this.doParse();
    }

    protected Document doParse() {
        DOMBuilderTagVisitor domBuilderTagVisitor = this.createDOMDomBuilderTagVisitor();
        this.parse(domBuilderTagVisitor);
        return domBuilderTagVisitor.getDocument();
    }

    protected DOMBuilderTagVisitor createDOMDomBuilderTagVisitor() {
        return new DOMBuilderTagVisitor(this);
    }

    public CData createCData(String cdata) {
        return new CData(this, cdata);
    }

    public Comment createComment(String comment) {
        return new Comment(this, comment);
    }

    public Comment createConditionalComment(String comment, boolean isStartingTag, boolean conditionalDownlevelHidden, String additionalComment) {
        return new Comment(this, comment, isStartingTag, conditionalDownlevelHidden, additionalComment);
    }

    public Document createDocument() {
        return new Document(this);
    }

    public Element createElement(Tag tag, boolean voidElement, boolean selfClosed) {
        return new Element(this, tag, voidElement, selfClosed);
    }

    public Element createElement(String name) {
        return new Element(this, name, false, false);
    }

    public Element createElement(String tagName, boolean voidElement, boolean selfClosed) {
        return new Element(this, tagName, voidElement, selfClosed);
    }

    public Text createText(String text) {
        return new Text(this, text);
    }

    public Text createText() {
        return new Text(this, null);
    }

    public DocumentType createDocumentType(String value, String publicId, String baseUri) {
        return new DocumentType(this, value, publicId, baseUri);
    }

    public XmlDeclaration createXmlDeclaration(Tag tag) {
        return new XmlDeclaration(this, tag);
    }

    public XmlDeclaration createXmlDeclaration(String string) {
        return new XmlDeclaration(this, string);
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public long getParsingTime() {
        return this.elapsed;
    }
}

